<?php

namespace Controller;
use Inc\Helper;
use Inc\Logger;
use Model\Coin;
use Model\Query;

/**
 * API calls
 * Class API
 * @package Controller
 */
class API extends Base {
  /**
   * Before route
   * Set JSON view
   */
  public function beforeroute($f3, $params) {
    parent::beforeroute($f3, $params);
    $this->view = new \View\JSON();
  }

  /**
   * Get coins data
   * @param $f3
   * @param $params
   */
  public function coins($f3, $params) {
    $this->view->data['coins'] = (new Query())->coins(
      $params['sort'],
      $params['dir'],
      intval($f3->get('SITE.COINS_LIMIT')),
      intval($params['offset']),
      $params['featured']==1
    );
  }

  /**
   * Get historical data for a particular coin
   * @param $f3
   * @param $params
   */
  public function history($f3, $params) {
    $symbol = preg_match('#^[A-Z0-9\^-]+$#', $params['symbol']) ? $params['symbol'] : Helper::coinSymbol($params['symbol']);
    $coin = new Coin($symbol);
    $this->view->data['history'] = $coin->dailyIntradayHistory();
  }

  /**
   * Search coins by symbol or name
   * @param $f3
   * @param $params
   */
  public function search($f3, $params) {
    $this->view->data['search'] = (new Query())->search($params['search']);
  }

  public function addFavorite($f3, $params) {
    $this->view->data['success'] = (new Coin($params['symbol']))->addFavorite();
    $this->view->data['message'] =
      $this->view->data['success'] ?
      $f3->get('text.favorites_add_success', [$params['symbol']]) :
      $f3->get('text.favorites_add_error', [$params['symbol']]);
  }

  public function removeFavorite($f3, $params) {
    $this->view->data['success'] = (new Coin($params['symbol']))->removeFavorite();
    $this->view->data['message'] =
      $this->view->data['success'] ?
        $f3->get('text.favorites_remove_success', [$params['symbol']]) :
        $f3->get('text.favorites_remove_error', [$params['symbol']]);
  }
}