<?php

namespace Controller;
use Inc\Logger;
use Inc\Helper;
use Model\Action;


/**
 * Run cron jobs
 * Class Cron
 * @package Controller
 */
class Cron extends Base {

  /**
   * Before route
   */
  public function beforeroute($f3, $params) {
    $this->view = new \View\JSON();
  }

  public function run($f3, $params) {
    if ($f3->get('SECURITY.TOKEN') == $params['token']) {
      Logger::log(sprintf('CRON started at %s', Helper::timeStamp()));
      set_time_limit(1800); // set time limit to 30 minutes
      $startTime = microtime(TRUE);
      $action = new Action();

      // update FX rates
      $this->view->data['currencies_updated'] = $action->updateCurrencyRates();

      // update coins data
      $this->view->data['coins_updated'] = $action->updateCoinData();

      $action->updateSitemap();
      
      Logger::log(sprintf('CRON finished at %s (exec time %.2f sec)', Helper::timeStamp(), microtime(TRUE) - $startTime));
    } else {
      Logger::log(sprintf('Incorrect token supplied for cron: %s', $params['token']), 3);
      // $f3->reroute('/');
      $f3->error(404);
    }
  }
}