<?php

namespace Controller;

use Inc\Helper;
use Inc\Logger;
use Model\Coin;
use Model\CurrencyRate;
use Model\Query;

class Page extends Base {

  /**
   * Before a page is routed
   * @param $f3
   * @param $params
   */
  public function beforeroute($f3, $params) {
    parent::beforeroute($f3, $params);
    $this->view->templateFolder = 'public';
    // Data required on all pages
    $query = new Query();
    $currencyRate = CurrencyRate::instance();
    $this->view->data['coins_overall_stats'] = $query->stats();
    $this->view->data['currencies_list'] = $currencyRate->all();
    $this->view->data['display_currency'] = $currencyRate->get();
    $this->view->data['languages_list'] = Helper::languages(true);
    $this->view->data['display_language'] = $f3->get('LANG');
    $this->view->data['risers'] = $query->risers();
    $this->view->data['fallers'] = $query->fallers();
    $this->view->data['donation_coins'] = $query->donationCoins();
    $this->view->data['page_theme'] = isset($_COOKIE['black_theme']) ? 'black-theme' : '';
  }

  /**
   * After page is routed
   * @param $f3
   * @param $params
   */
  public function afterroute($f3, $params) {
    // set title and meta variables
    $alias = $f3->get('ALIAS');
    $this->view->data['page_title'] = $alias=='page' ? Helper::slugToTitle($f3->get('PARAMS')['slug']) : $f3->get('site.title')[$alias];
    $this->view->data['page_meta_description'] = $alias=='page' ? Helper::slugToTitle($f3->get('PARAMS')['slug']) : $f3->get('site.meta_description')[$alias];
    if ($alias=='coin') {
      $this->view->data['favicon_mime_type'] = substr($this->view->data['coin']['logo'], -3)=='png' ? 'image/png' : 'image/jpeg';
    }

    parent::afterroute($f3, $params);
  }

  /**
   * Serve index page
   * @param $f3
   * @param $params
   */
  public function index($f3, $params) {
    $query = new Query();
    $this->view->data['coins'] = $query->coins(
      $f3->get('GET.sort'),
      $f3->get('GET.dir'),
      intval($f3->get('SITE.COINS_LIMIT')),
      0,
      $f3->get('GET.featured')==1
    );
  }

  public function risers($f3, $params) {
    $query = new Query();
    $this->view->data['coins'] = $query->coins(
      'change_pct',
      'DESC',
      intval($f3->get('SITE.RISERS_LIMIT'))
    );
  }

  public function fallers($f3, $params) {
    $query = new Query();
    $this->view->data['coins'] = $query->coins(
      'change_pct',
      'ASC',
      intval($f3->get('SITE.FALLERS_LIMIT'))
    );
  }

  /**
   * Serve particular coin page
   * @param $f3
   * @param $params
   */
  public function coin($f3, $params) {
    $coin = new Coin(Helper::coinSymbol($params['symbol']));
    $this->view->data['coin'] = $coin->data();
    $this->view->data['favorite'] = $coin->isFavorite();

    if (empty($this->view->data['coin']))
      // $f3->reroute('@index');
      $f3->error(404);
  }

  /**
   * Serve calculator page
   * @param $f3
   * @param $params
   */
  public function calculator($f3, $params) {
    $query = new Query();

    foreach ($query->coinsCurrenciesQuotes() as $coin) {
      $this->view->data['coins_list'][$coin['type']][$coin['symbol']] = $coin['name'];
      $this->view->data['coins_quotes'][$coin['symbol']] = ['quote' => $coin['quote'], 'type' => $coin['type']];
    }
  }

  /**
   * Generic static page handler
   * @param $f3
   * @param $params
   */
  public function staticPage($f3, $params) {
    $pathMask = 'app/templates/%s/%s.php';
    if (!file_exists(sprintf($pathMask, $this->view->templateFolder, $params['slug'])) && !file_exists(sprintf($pathMask, $this->view->templateFolder, $params['slug'].'-udf'))) {
      $f3->error(404);
    }
  }

  /**
   * Error page
   * @param $f3
   * @param $params
   */
  public function errorPage($f3, $params) {
    $f3->set('ALIAS', 'error');
  }
}