<?php

namespace Controller;

use Inc\Helper;
use Model\Coin;
use Model\Currency;

class Widget extends Base {

  /**
   * Before a page is routed
   * @param $f3
   * @param $params
   */
  public function beforeroute($f3, $params) {
    parent::beforeroute($f3, $params);
    $this->view->templateFolder = 'widget';
    // important to remove this header, so page can be embedded through iframe on other websites
    header_remove('X-Frame-Options');
  }

  /**
   * Serve index page
   * @param $f3
   * @param $params
   */
  public function widget($f3, $params) {
    $coinSymbol = $f3->get('GET.symbol') ? $f3->get('GET.symbol') : 'BTC';
    $currencySymbol = $f3->get('GET.currency') ? $f3->get('GET.currency') : 'USD';
    $coin = new Coin($coinSymbol);
    $this->view->data['coin'] = $coin->get(['symbol','name','logo','price','change','change_pct','ws_disabled'], $currencySymbol);
    $this->view->data['demo'] = $f3->get('GET.demo') ? TRUE : FALSE;
  }
}
