<?php
return [
	'site.name' => 'CoinCompare',
	'site.description' => 'CoinCompare is a PHP web application, which displays general information, real-time quotes, trades, interactive historical charts and twitter timeline feed for more than 2000 cryptocurrencies. It is designed to allow you quickly get a website like coinmarketcap.com up and running.',
	'site.title' => [
		'index'=>'Top cryptocurrencies',
		'coin'=>'{0} ({1}) info, quotes and charts',
		'risers'=>'Top risers',
		'fallers'=>'Top fallers',
		'favorites'=>'Favorite coins',
		'calculator'=>'Cryptocurrency calculator',
		'about'=>'About',
		'faq'=>'FAQ',
		'error'=>'Error',
		'login'=>'Login',
		'register'=>'Register',
		'password'=>'Recover password',
		'backend_settings'=>'Settings',
		'backend_banners'=>'Banners',
		'backend_coin'=>'Coin management',
		'backend_coins'=>'Coins management',
		'backend_download'=>'Download coins',
		'backend_strings'=>'Language strings overrides',
		'backend_cron'=>'Cron',
		'backend_help'=>'Help',
		'backend_update'=>'Update config & database',
		'backend_logs'=>'Logs'
	],
	'site.meta_description' => [
		'index'=>'Cryptocurrency info, quotes and charts',
		'coin'=>'{0} ({1}) info, quotes and charts',
		'risers'=>'Top risers',
		'fallers'=>'Top fallers',
		'favorites'=>'Favorite coins',
		'calculator'=>'Cryptocurrency calculator',
		'about'=>'Cryptocurrency info, quotes and charts',
		'faq'=>'Cryptocurrency info, quotes and charts',
		'error'=>'Error',
		'login'=>'Login',
		'register'=>'Register',
		'password'=>'Recover password',
		'backend_settings'=>'Settings',
		'backend_banners'=>'Banners',
		'backend_coin'=>'Coin management',
		'backend_coins'=>'Coins management',
		'backend_download'=>'Download coins',
		'backend_strings'=>'Language strings overrides',
		'backend_cron'=>'Cron',
		'backend_help'=>'Help',
		'backend_update'=>'Update config & database',
		'backend_logs'=>'Logs'
	],
	'site.meta_keywords' => 'cryptocurrency,digital currency,digital coin,bitcoin,ethereum,litecoin,ripple',
	'text.1d' => '1D',
	'text.1w' => '1W',
	'text.2w' => '2W',
	'text.1m' => '1M',
	'text.3m' => '3M',
	'text.6m' => '6M',
	'text.1y' => '1Y',
	'text.2y' => '2Y',
	'text.5y' => '5Y',
	'text.actions' => 'Actions',
	'text.active' => 'Active',
	'text.add' => 'Add ...',
	'text.all' => 'All',
	'text.about_header' => 'About',
	'text.accept' => 'Accept',
	'text.adsense_client_id' => 'Google AdSense client ID',
	'text.adsense_slot_id1' => 'Google AdSense slot ID (top of the page)',
	'text.adsense_slot_id2' => 'Google AdSense slot ID (bottom of the page)',
	'text.amount' => 'Amount',
	'text.annotate' => 'Annotate...',
	'text.api_settings' => 'API settings',
	'text.arrow' => 'Arrow',
	'text.back_all_coins' => 'Back to all coins',
	'text.backend' => 'Backend',
	'text.banners' => 'Banners',
	'text.banner_before' => 'Top banner',
	'text.banner_after' => 'Bottom banner',
	'text.breaking_news' => 'Breaking news',
	'text.built_using' => 'Built using',
	'text.buy_coin' => 'Buy {0}',
	'text.buy_link' => 'Coin buy link affiliate URL',
	'text.buy_link_tooltip' => '{0} will be automatically substituted with coin symbol',
	'text.btc_price' => 'Price in BTC',
	'text.calculator' => 'Cryptocurrency calculator',
	'text.cancel' => 'Cancel',
	'text.change' => '24h Change',
	'text.change2' => 'Change ...',
	'text.change_pct' => '24h % Change',
	'text.chart_candlestick' => 'Candlestick',
	'text.chart_column' => 'Column',
	'text.chart_line' => 'Line',
	'text.chart_period_default' => 'Default chart period',
	'text.chart_periods' => 'Period switch buttons',
	'text.chart_scrollbar_enabled' => 'Enable history scrollbar',
	'text.chart_short_number_format' => 'Use short number format',
	'text.chart_short_number_format_tooltip' => 'Use short number format for big values (e.g. "1K" instead of "1,000", "1M" instead of "1,000,000" etc)',
	'text.chart_smoothedLine' => 'Smoothed line',
	'text.chart_step' => 'Step',
	'text.chart_type_coin' => 'Coin chart type',
	'text.chart_type_volume' => 'Volume chart type',
	'text.close' => 'Close',
	'text.compare' => 'Compare to ...',
	'text.coin_page_settings' => 'Coin page settings',
	'text.coin_enabled_tabs' => 'Enabled tabs',
	'text.coin_page_key' => 'Coin page key',
	'text.coin_page_keys' => [
			'ucs' => 'Upper case symbol',
			'lcs' => 'Lower case symbol',
			'lcn' => 'Lower case name'
	],
	'text.coins_downloaded' => 'Number of new coins downloaded: {0}',
	'text.coins_inserted' => 'Number of new coins inserted to DB: {0}',
	'text.coins_management' => 'Coins management',
	'text.coins_realtime_feed' => 'Enable real-time quotes updates',
	'text.coins_quotes_updated' => 'Quotes for {0} coins updated',
	'text.coins_quotes_not_updated' => 'Coins quotes were NOT updated',
	'text.coins_number' => 'Number of coins displayed by default',
	'text.color' => 'Color schema',
	'text.color2' => 'Color ...',
	'text.convert_from' => 'Convert from',
	'text.convert_to' => 'Convert to',
	'text.cookie_consent' => 'This site uses cookies. By continuing to browse the site you are agreeing to our use of cookies',
	'text.cookie_policy' => 'Cookie policy',
	'text.cron' => 'Cron',
	'text.cron_run' => 'Run cron manually',
	'text.cron_description' => 'Cron job is required to automatically update coins and currencies quotes. Set up cron job as follows:',
	'text.cron_description2' => 'You can also run the market data update manually. Please be patient and do not refresh the page, it can take some time. Please also note that currencies rates will not be refreshed more than 1 time per hour due to API limitations.',
	'text.cryptocompare_api_key' => 'Cryptocompare.com API key',
	'text.cryptocompare_api_key_hint' => 'Cryptocurrency prices and other data is pulled from cryptocompare.com API. Please sign up and get a free API key. Input it below.',
	'text.cryptocurrency' => 'Cryptocurrency',
	'text.cryptocurrencies' => 'cryptocurrencies',
	'text.currencies_quotes_updated' => 'Quotes for {0} currencies updated',
	'text.currencies_quotes_not_updated' => 'Currencies quotes were NOT updated',
	'text.current_supply' => 'Current Supply',
	'text.currency' => 'Currency',
	'text.date' => 'Date',
	'text.decimal_point' => 'Decimal point',
	'text.description' => 'Description',
	'text.displayed_fields' => 'Displayed fields',
	'text.download_as' => 'Download as ...',
	'text.download_coins' => 'Download coins',
	'text.download_coins_text' => 'You can check if there are any new coins and automatically add them to the database. Please be patient, it might take a while. Market data for new coins will be updated after next cron run.',
	'text.download_coins_ext_required' => 'To be able to download new coins <u><a class="white-text" href="http://php.net/manual/en/book.fileinfo.php" target="_blank">fileinfo</a></u> and either <u><a class="white-text" href="http://php.net/manual/en/book.image.php" target="_blank">GD</a></u> or <u><a class="white-text" href="http://php.net/manual/en/book.imagick.php" target="_blank">ImageMagick</a></u> PHP extensions are required. Please install them before using this feature.',
	'text.developer_settings' => 'Developer settings',
	'text.edit' => 'Edit',
	'text.email' => 'Email',
	'text.email_from' => 'Email FROM address',
	'text.email_tooltip' => 'Email FROM address for all outgoing emails sent by the application.',
	'text.email_settings' => 'Email settings',
	'text.email_error' => 'There was an error while sending the email. Please contact the website admin or try again later.',
	'text.empty_table' => 'No data available',
	'text.encryption' => 'Encryption',
	'text.error_headers' => [
		'403' => 'Error 403',
		'404' => 'Error 404',
		'500' => 'Error 500',
	],
	'text.error_descriptions' => [
		'403' => 'Sorry, but you are not authorized to view this page.',
		'404' => 'Nothing is found. Are you looking for a cryptocurrency, which not yet exists?',
		'500' => 'Ooops, you have just ruined the blockchain. Please let us know, so we can do a hard fork ASAP!',
	],
	'text.delete_logs' => 'Delete log file',
	'text.donate' => 'Donate',
	'text.donate_text' => 'Please consider a small donation to keep our project alive.',
	'text.donation_addresses' => 'Donation addresses',
	'text.donation_addresses_tooltip' => 'Input comma-separated SYMBOL:ADDRESS pairs (SYMBOL should be a valid coin symbol).',
	'text.facebook_app_id' => 'Facebook App ID',
	'text.facebook_app_id_hint' => 'Facebook application ID is required for Facebook comments widget on coin pages.',
	'text.fallers_limit' => 'Fallers limit',
	'text.faq_header' => 'FAQ',
	'text.faq_headers' => [
		'Where is the data taken from?',
		'What is Market Capitalization and how is it calculated?',
		'What is the difference between Circulating Supply, Total Supply and Max Supply?',
		'Why is the Circulating Supply used in determining the market capitalization instead of Total Supply?',
	],
	'text.faq_descriptions' => [
		'<p>Live and historical cryptocurrency quotes are pulled from cryptocompare.com API.</p>',
		'<p>Market Capitalization is one way to rank the relative size of a cryptocurrency. It\'s calculated by multiplying the Price by the Circulating Supply.</p><p>Market Cap = Price X Circulating Supply.</p>',
		'<p>Circulating Supply is the best approximation of the number of coins that are circulating in the market and in the general public\'s hands. Total Supply is the total amount of coins in existence right now (minus any coins that have been verifiably burned). Max Supply the best approximation of the maximum amount of coins that will ever exist in the lifetime of the cryptocurrency.</p>',
		'<p>Circulating Supply is a much better metric for determining the market capitalization. Coins that are locked, reserved, or not able to be sold on the public market are coins that can\'t affect the price and thus should not be allowed to affect the market capitalization as well. The method of using the Circulating Supply is analogous to the method of using public float for determining the market capitalization of companies in traditional investing.</p>'
	],
	'text.favorites' => 'Favorite coins',
	'text.favorites_add' => 'Add to favorites',
	'text.favorites_add_success' => '{0} added to your favorites list',
	'text.favorites_add_error' => 'There was an error while adding {0} to your favorites list',
	'text.favorites_page_settings' => 'Favorites page settings',
	'text.favorites_remove' => 'Remove from favorites',
	'text.favorites_remove_success' => '{0} removed from your favorites list',
	'text.favorites_remove_error' => 'There was an error while removing {0} to your favorites list',
	'text.favorites_empty'=>'You have not added any coins to favorites.',
	'text.featured' => 'featured',
	'text.featured_coin' => 'Featured',
	'text.features' => 'Features',
	'text.featured_coins' => 'Featured coins',
	'text.featured_coins_tooltip' => 'Input comma separated list of symbols, e.g. BTC,ETH,XRP. Selected coins will be highlighted on the front page.',
	'text.first' => 'First',
	'text.first_name' => 'First name',
	'text.front_page' => 'Front page',
	'text.front_page_settings' => 'Front page settings',
	'text.google_tracking_id' => 'Google Analytics tracking ID',
	'text.help' => 'Help',
	'text.hide' => 'Hide',
	'text.high' => '24h High',
	'text.historical_data' => 'Historical data',
	'text.incorrect_login' => 'Incorrect login and / or password',
	'text.id' => 'ID',
	'text.info' => 'Info',
	'text.info_all' => 'Displaying _START_ to _END_ of _TOTAL_ entries',
	'text.info_filtered' => '(filtered from _MAX_ total entries)',
	'text.intraday_quotes' => '24h Performance',
	'text.key_indicators' => 'Key indicators',
	'text.last_updated' => 'Last updated',
	'text.language' => 'Website language',
	'text.last' => 'Last',
	'text.last_name' => 'Last name',
	'text.line' => 'Line',
	'text.load_more' => 'Load more coins',
	'text.logs' => 'Logs',
	'text.logs_empty' => 'There are no logs yet. Enable logging in Developer settings to see the application logs. It\'s recommended to keep this setting off in the live environment.',
	'text.log_level' => 'Log level',
	'text.login' => 'Log in',
	'text.login_text' => 'Already have an account?',
	'text.login_text2' => 'Do not have an account?',
	'text.login_period' => 'Admin session expiry time (requires re-login to take in effect)',
	'text.login_period_options' => ['86400' => '1 day', '432000' => '5 days', '2592000' => '30 days', '7776000' => '90 days'],
	'text.logout' => 'Log out',
	'text.low' => '24h Low',
	'text.market' => 'Market',
	'text.market_cap' => 'Market cap',
	'text.market_share' => 'Market share',
	'text.main_settings' => 'Main settings',
	'text.max' => 'MAX',
	'text.mode' => 'Mode ...',
	'text.monetization' => 'Monetization',
	'text.name' => 'Name',
	'text.next' => 'Next',
	'text.news_feed_settings' => 'News Feed Settings',
	'text.none' => 'None',
	'text.no_subs' => 'No real-time trades subscriptions available for selected coin and display currency.',
	'text.short_number_format' => ['K' => 'K', 'M' => 'M', 'B' => 'B'],
	'text.opacity' => 'Opacity ...',
	'text.open' => '24h Open',
	'text.open_cryptocompare' => 'See on cryptocompare.com',
	'text.openexchangerates_app_id' => 'Openexchangerates.org App ID',
	'text.openexchangerates_app_id_hint' => 'Fiat currencies rates are pulled from openexchangerates.org. Please sign up and get a free API key (App ID). Input it below.',
	'text.password' => 'Password',
	'text.password_recovery' => 'Password recovery',
	'text.password_recovery_text' => 'Someone has requested a new password for your account at <a class="mc-template-link" href="{0}" target="_blank">{1}</a>.',
	'text.password_recovery_text2' => 'Your new password is: <b>{0}</b>',
	'text.password_recovery_text3' => '<a class="mc-template-link" href="{0}" target="_blank">Log in</a> with your new password.',
	'text.password_sent' => 'The new password has just been sent to the provided email.',
	'text.pencil' => 'Pencil',
	'text.previous' => 'Previous',
	'text.print' => 'Print',
	'text.proof_type' => 'Proof type',
	'text.price' => 'Price',
	'text.proudly_built' => 'Proudly built by',
	'text.purchase' => 'Purchase',
	'text.read_more' => 'Read more',
	'text.recover_password' => 'Recover password',
	'text.redo' => 'Redo',
	'text.register' => 'Register',
	'text.require_cookie_acceptance' => 'Require visitors to accept use of cookies',
	'text.risers_fallers_page_settings' => 'Risers / fallers page settings',
	'text.risers_limit' => 'Risers limit',
	'text.rss_url' => 'RSS feed URL',
	'text.rss_speed' => 'Scroll speed',
	'text.rss_delay' => 'Pause between news items (in seconds)',
	'text.save' => 'Save',
	'text.save_as' => 'Save as ...',
	'text.saved_from' => 'Saved from: ',
	'text.search' => 'Search',
	'text.search_coins' => 'Search coins...',
	'text.search_not_found' => 'No results found',
	'text.search_error' => 'There was an error, please try again.',
	'text.search_short' => 'Enter at least 2 characters',
	'text.security_settings' => 'Security',
	'text.sell_coin' => 'Sell {0}',
	'text.sell_link' => 'Coin sell link affiliate URL',
	'text.sell_link_tooltip' => '{0} will be automatically substituted with coin symbol',
	'text.settings' => 'Settings',
	'text.settings_saved' => 'Settings saved',
	'text.settings_not_saved' => 'Settings NOT saved',
	'text.s_upload_logo' => 'Custom website logo',
	'text.s_uploaded_logo' => 'Uploaded logo',
	'text.s_uploaded_logo_remove' => 'Remove custom website logo',
	'text.side_menu_language' => 'Language',
	'text.side_menu_currency' => 'Display currency',
	'text.side_menu_currency_placeholder' => 'Currency name...',
	'text.sign_up' => 'Sign up',
	'text.size' => 'Size ...',
	'text.smtp_host' => 'SMTP host',
	'text.smtp_host_tooltip' => 'SMTP host or IP address if you use an external SMTP server. Leave empty to use default mail function of your server.',
	'text.smtp_port' => 'SMTP port',
	'text.smtp_port_tooltip' => 'SMTP port if you use an external SMTP server. Leave empty to use default mail function of your server.',
	'text.smtp_user' => 'SMTP user',
	'text.smtp_user_tooltip' => 'SMTP user / login if you use an external SMTP server. Leave empty to use default mail function of your server.',
	'text.smtp_password' => 'SMTP password',
	'text.smtp_password_tooltip' => 'SMTP password if you use an external SMTP server. Leave empty to use default mail function of your server.',
	'text.shape' => 'Shape ...',
	'text.social' => 'Social',
	'text.social_settings' => 'Social Settings',
	'text.sort_column' => 'Default sort column',
	'text.sort_column_options' => ['name'=>'Name','price'=>'Price','change_pct'=>'% Change','volume'=>'Volume','volume_ccy'=>'Volume (currency)','total_volume'=>'Total Volume','total_volume_ccy'=>'Total Volume (currency)','supply'=>'Supply','market_cap'=>'Market Cap'],
	'text.sort_order' => 'Default sort order',
	'text.sort_order_options' => ['ASC' => 'Ascending', 'DESC' => 'Descending'],
	'text.ssl' => 'SSL',
	'text.string_original' => 'Original string',
	'text.string_override' => 'String override',
	'text.strings_overrides' => 'Language strings overrides',
	'text.supply' => 'Supply',
	'text.text' => 'Text',
	'text.technology' => 'Technology',
	'text.theme_change' => 'Day / night mode',
	'text.thousands_separator' => 'Thousands separator',
	'text.tls' => 'TLS',
	'text.top_risers' => 'Top risers',
	'text.top_fallers' => 'Top fallers',
	'text.total' => 'Total',
	'text.total_market_cap' => 'Total Market Cap',
	'text.total_supply' => 'Total Supply',
	'text.total_volume' => '24h Total Volume',
	'text.total_volume_coin' => '24h Total volume (coin)',
	'text.total_volume_ccy' => '24h Total volume (currency)',
	'text.trade_buy' => 'BUY',
	'text.trade_sell' => 'SELL',
	'text.trade_unknown' => 'unknown',
	'text.trades' => 'Trades',
	'text.tracking_settings' => 'Visitors Tracking',
	'text.type' => 'Type',
	'text.twitter' => 'Twitter',
	'text.undo' => 'Undo',
	'text.user_exists' => 'User with this email is already registered.',
	'text.usd' => 'USD',
	'text.unhide' => 'Unhide',
	'text.update' => 'Update',
	'text.update_config' => 'Update config & database',
	'text.update_config_error' => 'Something went wrong...',
	'text.update_config_success' => 'Updated successfully',
	'text.update_config_description' => 'Update is only required once after you installed a new release. You do not need to run it again until next update.',
	'text.update_config_required' => 'It looks like you have recently installed a new application release. Please update system config file and database.',
	'text.update_subs' => 'Update coins real-time subscriptions',
	'text.update_subs_tooltip' => 'Update the list of supported real-time trade data subscriptions for each existing coin. This will take longer and should not be used too often.',
	'text.quantity' => 'Quantity',
	'text.visit_website' => 'Visit website',
	'text.version' => 'Version',
	'text.view_all' => 'View all',
	'text.volume' => 'Volume',
	'text.volume_coin' => '24h Volume (coin)',
	'text.volume_ccy' => '24h Volume (currency)',
	'text.website' => 'Website',
	'text.widget' => 'Widget',
	'text.widget_code' => 'Widget code',
	'text.widget_copy' => 'Copy widget code',
	'text.widget_text' => 'To embed real-time {0} widget into your website copy the following code. ',
	'text.ws_disabled' => 'Disable real-time quotes updates',
	'text.ytd' => 'YTD',
];