<?php

namespace Inc;

/**
 * Class Database - Singleton
 * @package Helper
 */
class Database extends \Prefab {
  const DSN = 'mysql:host=%s;port=%d;dbname=%s';
  private $connection;

  // using protected constructor for singleton, so it can't be instantiated like a normal class
  protected function __construct() {
    $f3 = \Base::instance();
    $this->connection = new \DB\SQL(
      sprintf(self::DSN, $f3->get('DB.HOST'), $f3->get('DB.PORT'), $f3->get('DB.DATABASE')),
      $f3->get('DB.USER'),
      $f3->get('DB.PASSWORD'),
      [\PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION]
    );
    Logger::log(sprintf('Connected to DB: %s', $this->connection->uuid()), 3);
  }

  /**
   * Run an arbitrary SQL query
   * @param $sql
   * @param null $args
   * @return array|FALSE|int
   */
  public function exec($sql, $args = NULL) {
    $result = $this->connection->exec($sql, $args);
    // log() functions returns all SQL queries, which were executed up to this call, so need to retrieve the last query only
    $log = explode('!!!', trim(preg_replace(['#\([0-9]+\.[0-9]+ms\)\s*#','#\s+#',],['!!!',' ',], $this->connection->log()), '!!!'));
    Logger::log($log[count($log)-1], 3);
    return $result;
  }

  /**
   * Get \DB\SQL instance
   * @return \DB\SQL
   */
  public function connection() {
    return $this->connection;
  }

  public function uuid() {
    return $this->connection->uuid();
  }
}