<?php

namespace Inc;

/**
 * Class Logger
 */
class Logger {
  const LOG_FILE = 'logs/trace.log';

  /**
   * Log message
   * @param $message
   * @param int $level
   */
  public static function log($message, $level = 1) {
    $f3 = \Base::instance();
    if ($f3->get('DEBUG') && $f3->get('DEBUG') >= $level) {
      (new \Log(self::LOG_FILE))->write(sprintf('%s', is_string($message) ? $message : print_r($message, TRUE)));
    }
  }

  /**
   * Delete log file
   */
  public static function purge() {
    return unlink(self::LOG_FILE);
  }
}