<?php
namespace Model;
use Inc\Helper;

/**
 * Class Currency - functions for a specific currency
 * @package Model
 */
class Currency extends Base {
  private $symbol;

  public function __construct($symbol) {
    parent::__construct();
    $this->symbol = $symbol;
    return $this;
  }

  /**
   * Update coin market data
   * @param $fields
   * @return mixed
   */
  public function update($fields) {
    return $this->db->exec('UPDATE currency SET
                              rate = :rate,
                              last_updated = :last_updated
                            WHERE symbol = :symbol',
      [
        ':rate'         => $fields['rate'],
        ':last_updated' => Helper::timeStamp(),
        ':symbol'       => $this->symbol,
      ]
    );
  }

  /**
   * Get currency info
   * @param $fields
   * @return array|null
   */
  public function get(array $fields = ['symbol']) {
    $result = $this->db->exec('SELECT ' . implode(',', $fields) . ' FROM currency WHERE symbol = :symbol', [':symbol' => $this->symbol]);
    return isset($result[0]) ? $result[0] : [];
  }
}