<set page="{{ @GET.page ? intval(@GET.page) : 1 }}" />
<set search="{{ @GET.search }}" />
<!--Main content-->
<section id="content" class="container">
  <!--Coins-->
  <section>
    <div class="row">
      <div class="col s12">
        <h1 class="primary-text">
          {{ @text.coins_management }}
        </h1>
        <div class="divider"></div>
      </div>
    </div>
    <div class="row">
      <div class="col s12 m6 l4 xl3">
        <div class="search-wrapper card">
          <input id="search-coins-input" name="search" placeholder="{{ @text.search_coins }}" value="{{ @search }}"><i id="search-coins-button" class="material-icons">search</i>
        </div>
      </div>
      <div class="col s12">
        <table id="coins-list" class="bordered highlight">
          <thead>
            <tr>
              <th>{{ @text.cryptocurrency }}</th>
              <th class="right-align">{{ @text.sort_column_options.price }}, {{ @text.usd }}</th>
              <th class="right-align">{{ @text.sort_column_options.supply }}</th>
              <th class="right-align"><i class="material-icons">arrow_drop_down</i> {{ @text.sort_column_options.market_cap }}, {{ @text.usd }}</th>
              <th class="right-align">{{ @text.actions }}</th>
            </tr>
          </thead>
          <tbody>
            <check if="{{ @vars.coins }}">
              <true>
                <repeat group="{{ @vars.coins }}" key="{{ @i }}" value="{{ @coin }}">
                  <tr {{ !@coin.active ? 'class="inactive"' : '' }}>
                    <td data-title="{{ @text.cryptocurrency }}">
                      <img src="assets/images/coins/thumb30/{{ @coin.logo }}" alt="{{ @coin.name }}" title="{{ @coin.name }}">
                      <span>[{{ @coin.symbol }}] {{ @coin.name }}</span>
                      <check if="{{ @coin.featured }}">
                        <span data-badge-caption="{{ @text.featured }}" class="new {{ @SITE.COLOR }} badge"></span>
                      </check>
                    </td>
                    <td class="right-align">{{ @coin.price }}</td>
                    <td class="right-align">{{ @coin.supply }}</td>
                    <td class="right-align">{{ @coin.market_cap }}</td>
                    <td class="right-align">
                      <form action="{{ @REALM }}" method="post" class="coin-hide-unhide">
                        <input type="hidden" name="action" value="hide_unhide">
                        <input type="hidden" name="symbol" value="{{ @coin.symbol }}">
                        <input type="hidden" name="value" value="{{ intval(!@coin.active) }}">
                        <button type="submit" class="waves-effect waves-light btn btn-floating">
                          <check if="{{ @coin.active }}">
                            <true>
                              <i class="material-icons" title="{{ @text.hide }}">visibility_off</i>
                            </true>
                            <false>
                              <i class="material-icons" title="{{ @text.unhide }}">visibility</i>
                            </false>
                          </check>
                        </button>
                      </form>
                      <a href="{{ @BASE }}{{ 'backend_coin','symbol='.@coin.symbol | alias }}" class="waves-effect waves-light btn btn-floating"><i class="material-icons" title="{{ @text.edit }}">edit</i></a>
                      <a href="https://www.cryptocompare.com/coins/{{ strtolower(@coin.symbol) }}/overview/USD" class="waves-effect waves-light btn btn-floating" target="_blank"><i class="material-icons" title="{{ @text.open_cryptocompare }}">open_in_new</i></a>
                    </td>
                  </tr>
                </repeat>
              </true>
              <false>
                <tr>
                  <td colspan="5" class="center-align">{{ @text.search_not_found }}</td>
                </tr>
              </false>
            </check>
          </tbody>
        </table>
      </div>
    </div>
    <check if="{{ @vars.coins }}">
      <div class="row">
      <div class="col s12 center-align">
        <ul class="pagination">
          <check if="{{ @page==1 }}">
            <true>
              <li class="disabled">
                <a><i class="material-icons">chevron_left</i></a>
              </li>
            </true>
            <false>
              <li class="waves-effect">
                <a href="{{ @BASE }}{{ 'backend_coins' | alias }}?search={{ @search }}&page={{ @page-1 }}"><i class="material-icons">chevron_left</i></a>
              </li>
            </false>
          </check>
          <check if="{{ @vars.pages_count > 8 }}">
            <true>
              <check if="{{ @page <= 3 }}">
                <true>
                  <repeat group="{{ range(1,4) }}" value="{{ @i }}">
                    <li class="{{ @page==@i ? 'active' : 'waves-effect' }}"><a href="{{ @BASE }}{{ 'backend_coins' | alias }}?search={{ @search }}&page={{ @i }}">{{ @i }}</a></li>
                  </repeat>
                </true>
                <false>
                  <li class="waves-effect"><a href="{{ @BASE }}{{ 'backend_coins' | alias }}?search={{ @search }}&page=1">1</a></li>
                  <li>...</li>
                </false>
              </check>
              <check if="{{ @page > 3 && @page < @vars.pages_count-2 }}">
                <repeat group="{{ [@page -2,@page -1,@page,@page+1,@page+2] }}" value="{{ @i }}">
                  <li class="{{ @page==@i ? 'active' : 'waves-effect' }}"><a href="{{ @BASE }}{{ 'backend_coins' | alias }}?search={{ @search }}&page={{ @i }}">{{ @i }}</a></li>
                </repeat>
              </check>
              <check if="{{ @page >= @vars.pages_count-2 }}">
                <true>
                  <repeat group="{{ [@vars.pages_count-3,@vars.pages_count-2,@vars.pages_count-1,@vars.pages_count] }}" value="{{ @i }}">
                    <li class="{{ @page==@i ? 'active' : 'waves-effect' }}"><a href="{{ @BASE }}{{ 'backend_coins' | alias }}?search={{ @search }}&page={{ @i }}">{{ @i }}</a></li>
                  </repeat>
                </true>
                <false>
                  <li>...</li>
                  <li class="waves-effect"><a href="{{ @BASE }}{{ 'backend_coins' | alias }}?search={{ @search }}&page={{ @vars.pages_count }}">{{ @vars.pages_count }}</a></li>
                </false>
              </check>
            </true>
            <false>
              <repeat group="{{ range(1,@vars.pages_count) }}" value="{{ @i }}">
                <li class="{{ @page==@i ? 'active' : 'waves-effect' }}"><a href="{{ @BASE }}{{ 'backend_coins' | alias }}?search={{ @search }}&page={{ @i }}">{{ @i }}</a></li>
              </repeat>
            </false>
          </check>
          <check if="{{ @page==@vars.pages_count }}">
            <true>
              <li class="disabled">
                <a><i class="material-icons">chevron_right</i></a>
              </li>
            </true>
            <false>
              <li class="waves-effect">
                <a href="{{ @BASE }}{{ 'backend_coins' | alias }}?search={{ @search }}&page={{ @page+1 }}"><i class="material-icons">chevron_right</i></a>
              </li>
            </false>
          </check>
        </ul>
      </div>
    </div>
    </check>
  </section>
  <!--END Coins-->
</section>