<!--Main content-->
<section id="content" class="container">
  <!--Help-->
  <section>
    <div class="row">
      <div class="col s12">
        <h1 class="primary-text">
          {{ @text.help }}
        </h1>
        <div class="divider"></div>
      </div>
    </div>
    <div class="row">
      <div class="col s12">
        <ul class="collapsible" data-collapsible="accordion">
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>Which API is used to pull market data?</div>
            <div class="collapsible-body">
              <p>
                There are 2 sources of market data: cryptocompare.com and openexchangerates.org. The former is used to pull
                real-time and historical <b>cryptocurrencies</b> data (BTC/USD, ETH/USD etc).
                The latter is used to pull <b>fiat currencies</b> quotes (EUR/USD, GBP/USD etc).
              </p>
              <p>
                No API key is required to pull cryptocurrencies data.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>Why is "24h Performance" column empty after installation?</div>
            <div class="collapsible-body">
              <p>
                The sparkline chart display intraday price movements of a coin. The intraday quotes are saved after each cron run.
                So once you set up a cron job to regurarly pull market data and after it runs few times you will see the sparkline chart.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to change site name and other text strings?</div>
            <div class="collapsible-body">
              <p>All text strings for any language (like site name, description, meta tags etc) can be easily modified on
                <a href="{{ @BASE }}{{ 'backend_strings' | alias }}">Language strings overrides</a> page. Overriden text strings are stored
                separately from system strings, so they will be preserved during future application updates and you won't have to change
                them more than once. Do not modify system text strings manually in files inside <b>app/dict</b> folder.
                </a>
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to change header and footer?</div>
            <div class="collapsible-body">
              <p>
                Header and footer templates can be overriden with your custom templates. To add a custom header template
                create a file called <b>header-udf.php</b> in <b>app/templates/public</b> folder. To add a custom footer template
                create a file called <b>footer-udf.php</b> in the same folder. To start with, you can copy the original HTML markup from
                <b>header.php</b> and <b>footer.php</b> files respectively. With this approach your customized header and footer will not
                get wiped out with next application update. Do not modify system <b>header.php</b> and <b>footer.php</b> files directly.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to change the application logo?</div>
            <div class="collapsible-body">
              <p>
                Upload your custom logo to <b>assets/images</b> folder and rename the file to <b>logo-udf.png</b>. Don't change the
                default logo, otherwise it will get overwritten during next update.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How can I change the preview image on social networks?</div>
            <div class="collapsible-body">
              <p>
                To change the preview image that appears when you share a link to the app on Facebook, Twitter, LinkedIn, Google+ etc
                upload your custom banner to <b>assets/images/social</b> folder and rename the file to <b>coin-compare-banner-udf.png</b>.
                Recommended image size is 1200 x 630 pixels.
                Don't change the default banner, otherwise it will get overwritten during next update.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to add a new static text page?</div>
            <div class="collapsible-body">
              <p>
                Let's say you want to add a new page called "About us" with some static text (information). To make it happen
                just create a new template file <b>about-us-udf.php</b> (note that "-udf" suffix should always be present in the template file name for every custom page you add)
                inside <b>app/templates/public</b> folder and add necessary HTML markup. This page will then be automatically accessible
                via <b>{{@SCHEME.'://'.@HOST.@BASE.'/page/about-us'}}</b> link.
              </p>
              <p>
                Using the same technique you can override default FAQ page template by creating a file <b>faq-udf.php</b> inside <b>app/templates/public</b> folder.
                Do not modify the original <b>faq.php</b> file to be able to keep your custom changes after future application updates.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to change the default coin page path?</div>
            <div class="collapsible-body">
              <p>
                If you want each coin page to have a different URL, for instance <b>/crypto/BTC</b> instead of default <b>/coin/BTC</b>
                you need to add a custom route in <b>config/routes-udf.ini</b>. Here is an example:
              </p>
              <pre><code class="language-ini">[routes]
GET @coin: /crypto/@symbol=Controller\Page->coin</code></pre>
              <p>
                After that the default path will still work, so if you want to disable it you will need to set up a redirect from the old path
                to the new one as follows (add it to the same file):
              </p>
              <pre><code class="language-ini">[redirects]
GET /coin/@symbol=/crypto/@symbol</code></pre>
              <p>
                Do not modify the system <b>config/routes.ini</b> file as next update will wipe out your custom changes.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to add custom CSS rules?</div>
            <div class="collapsible-body">
              <p>
                Create a file called <b>style-udf.css</b> inside <b>assets/css</b> folder and add your custom styles there.
                This file will not be overwritten, so you will keep your custom changes after future upgrades.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to hide a specific coin?</div>
            <div class="collapsible-body">
              <p>
                To hide a specific coin from display open <a href="{{ @BASE }}{{ 'backend_coins' | alias }}">Coins management</a> page,
                locate the coin you would like to hide and click <b>Hide</b> button (or click <b>Edit</b>
                and then unset the <b>Active</b> flag).
              </p>
              <p>
                If you like to bulk hide coins it will be easier to achieve by running a SQL query through PHPMyAdmin (available from cPanel and Plesk) or any other
                MySQL database management software. For instance, to hide all coins, <b>but</b> Bitcoin, Ethereum and Ripple you need to run the following
                query:
              </p>
              <pre><code class="language-sql">UPDATE coin SET active = 0 WHERE symbol NOT IN ('BTC','ETH','XRP');</code></pre>
              <p>
                To hide all coins which don't have either supply or market cap values populated use this query:
              </p>
              <pre><code class="language-sql">UPDATE coin SET active = 0 WHERE supply = 0 OR market_cap = 0;</code></pre>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>What should I do if I see an incorrect price or market cap value for some coin?</div>
            <div class="collapsible-body">
              <p>
                Because all market data is pulled from <a href="https://cryptocompare.com" target="_blank">cryptocompare.com</a>
                in 99.99% of the cases the issue is on the API side. If you see an unknown coin tops the cryptocurrencies list
                check its current supply and market cap values on cryptocompare.com website. If you feel that some value is incorrect the best way
                to address it is to let them know directly through the Send feedback form (a link is available at the bottom of cryptocompare.com website).
                While they fix it you can hide such coin from display on your website.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to change coins descriptions?</div>
            <div class="collapsible-body">
              <p>
                Open <a href="{{ @BASE }}{{ 'backend_coins' | alias }}">Coins management</a> page, locate the coin you would like
                to update the description for and click <b>Edit</b> button on the right. Edit the description and hit <b>Save</b>.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to hide Info tab for all coins?</div>
            <div class="collapsible-body">
              <p>
                Open <a href="{{ @BASE }}{{ 'backend_settings' | alias }}">Settings</a> page, expand <b>{{ @text.coin_page_settings }}</b>
                and uncheck <b>Info</b> option. Save the settings.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to login to backend?</div>
            <div class="collapsible-body">
              <p>
                After your session expires you can login again at
                <a href="{{@SCHEME.'://'.@HOST.@BASE}}{{ 'login' | alias }}">{{@SCHEME.'://'.@HOST.@BASE}}{{ 'login' | alias }}</a>
                (just add <b>/login</b> to your the URL where the app is installed).
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How to modify sliding menu items?</div>
            <div class="collapsible-body">
              <p>
                To modify existing or add new custom links to the sliding menu in the front-end override the system menu template
                by creating a file called <b>menu-udf.php</b> in <b>app/templates/public</b> folder. You can create it as an exact copy
                of the system menu template and then modify it as needed. For example, you can add a link to "About us" page as follows:
              </p>
              <pre><code class="language-markup">{{ htmlentities('<li><a href="page/about-us" class="waves-effect"><i class="material-icons">info_outline</i>About us</a></li>') }}</code></pre>
              <p>
                You can use <a href="http://materializecss.com/icons.html" target="_blank">Materialize CSS icons</a> for the menu items.
                Do not modify system <b>menu.php</b> directly as your changes will be lost after next application update.
              </p>
            </div>
          </li>
          <li>
            <div class="collapsible-header"><i class="material-icons">help_outline</i>How does the real-time data feed work?</div>
            <div class="collapsible-body">
              <p>
                Real-time quotes are retrieved by the API from multiple cryptocurrency exchanges, aggregated over the last 24 hours on the API side and then
                streamed back to your website. It's important to understand that each particular price is an aggregated quote and hence
                it will not be the same as the last trade price on any given exchange, so comparing these quotes against
                last trades prices (see Trades tab on the coin page) is not correct.
              </p>
              <p>
                Another important aspect is currency conversion. The majority of cryptocurrencies trading is done in USD.
                Real-time quotes are always received in USD as other currencies have much less liquidity. When you choose another
                display currency on the website (e.g. EUR, GBP etc) the quotes will be simply converted using latest fiat currencies rates (EUR/USD, GBP/USD etc).
              </p>
              <p>
                Please note that the above conversion doesn't apply to trades feed.
                Subscription to real-time trades data is always made in a specific currency. So it well may be the case that you see a lot
                of trades being made in USD, but when you switch to another currency there could be no trades at all.
              </p>
              <p>
                Does the real-time data feed create an extra pressure on my server? Absolutely not. The real-time data feed is based
                on the <b>WebSocket</b> protocol. It basically means that the quotes are streamed from the API directly
                to the visitor browser (bypassing your server).
              </p>
              <p>
                Please also note that real-time data might not be available for not frequently traded coins. Even if it's available
                it's not possible to predict whether next quote will be received in 1 second or few minutes.
              </p>
            </div>
          </li>
        </ul>
      </div>
    </div>
  </section>
  <!--END Help-->
</section>