<script type="text/javascript">
  var MESSAGES = JSON.parse('{{ json_encode(\Inc\Flash::instance()->getMessages()) }}');
</script>
<section class="container">
  <header>
    <div class="row">
      <div class="col s12">
        <h1 class="primary-text">
          Installation
        </h1>
        <div class="divider"></div>
      </div>
    </div>
  </header>
  <section>
    <check if="{{ @vars.step==1 }}">
      <check if="{{ @vars.env_issues }}">
        <true>
          <div class="row">
            <div class="col s12">
              <p>
                The installation can not proceed, because some of the system requirements are not met. Please resolve the below issues:
              </p>
              <ul class="collection">
                <repeat group="{{ @vars.env_issues }}" value="{{ @issue }}">
                  <li class="collection-item">{{ @issue }}</li>
                </repeat>
              </ul>
            </div>
          </div>
        </true>
        <false>
          <div class="row">
            <div class="col s12">
              <p>
                Please register your license by providing the purchase code and your (license holder) email below.
              </p>
            </div>
            <div class="col s12">
              <form action="{{ @BASE }}{{ 'install' | alias }}" method="POST">
                <div class="row">
                  <div class="input-field col s12 m6">
                    <input placeholder="" id="code" name="code" type="text" value="{{ @ENVATO.PURCHASE_CODE }}" required>
                    <label for="code">Purchase code</label>
                  </div>
                </div>
                <div class="row">
                  <div class="input-field col s12 m6">
                    <input placeholder="" id="email" name="email" type="email" value="{{ @vars.email }}" required>
                    <label for="email">Email</label>
                  </div>
                </div>
                <div class="row">
                  <div class="input-field col s12 m6">
                    <button class="waves-effect waves-light btn-large" type="submit">Next</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </false>
      </check>
    </check>
    <check if="{{ @vars.step==2 }}">
      <div class="row">
        <div class="col s12">
          <p>
            Before installing the application you need to create a MySQL database and provide its connection details below.
            Please note that this installer will not create it for you, this needs to be done separately through website management panel
            like cPanel or Pleask or through the server command line (in case you have got a dedicated server). Don't use double quote (")
            and backslash (\) in the password field.
          </p>
        </div>
        <div class="col s12">
          <form action="{{ @BASE }}{{ 'install' | alias }}" method="POST">
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="localhost" id="host" name="host" type="text" class="validate" value="{{ @DB.HOST }}" required>
                <label for="host">Database host</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="3306" id="port" name="port" type="text" class="validate" value="{{ @DB.PORT }}" required>
                <label for="port">Port</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="coincompare" id="database" name="database" type="text" class="validate" value="{{ @DB.DATABASE }}" required>
                <label for="database">Database name</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="login" id="user" name="user" type="text" class="validate" value="{{ @DB.USER }}" required>
                <label for="user">Database user</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="secret password" id="password" name="password" type="password" class="validate" value="{{ @DB.PASSWORD }}" required>
                <label for="password">Database password</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <button class="waves-effect waves-light btn-large" type="submit">Next</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </check>
    <check if="{{ @vars.step==3 }}">
      <div class="row">
        <div class="col s12">
          <p>
            MySQL tables are successfully created!
          </p>
          <p>
            Please specify admin user account details below. Keep these credentials,
            so you can access the backend after installation is completed.
          </p>
        </div>
        <div class="col s12">
          <form action="{{ @BASE }}{{ 'install' | alias }}" method="POST">
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="john@smith.com" id="email" name="email" type="email" class="validate" value="{{ @vars.email }}" required>
                <label for="email">Email</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="backend password" id="password" name="user_password" type="password" class="validate" value="{{ @vars.user_password }}" required>
                <label for="password">Password</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <button class="waves-effect waves-light btn-large" type="submit">Next</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </check>
    <check if="{{ @vars.step==4 }}">
      <div class="row">
        <div class="col s12">
          <p>
            Admin user is successfully created!
          </p>
          <p>
            Please choose default display currency and provide <b>cryptocompare.com</b> and <b>openexchangerates.org</b> API keys.
            These APIs are used to pull cryptocurrency and fiat currency quotes respectively. You can obtain the keys
            by signing up for FREE at
            <a href="https://min-api.cryptocompare.com" target="_blank">https://min-api.cryptocompare.com</a>
            and
            <a href="https://openexchangerates.org/signup/free" target="_blank">https://openexchangerates.org/signup/free</a>.
          </p>
          <p>
            Click "Next" when done and current market data will be pulled and inserted into the database.
            Please be patient, it might take some time.
          </p>
        </div>
        <div class="col s12">
          <form action="{{ @BASE }}{{ 'install' | alias }}" method="POST">
            <div class="row">
              <div class="input-field col s12 m6">
                <select name="currency">
                  <repeat group="{{ @vars.currencies_list }}" key="{{ @key }}" value="{{ @item }}">
                    <option value="{{ @key }}" {{ @SITE.CURRENCY == @key ? 'selected' : '' }}>{{ @item.name }}</option>
                  </repeat>
                </select>
                <label>Default currency</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="API key" id="cryptocompare_key" name="cryptocompare_key" type="text" class="validate" value="{{ @API.CRYPTOCOMPARE_API_KEY }}" required>
                <label for="cryptocompare_key">cryptocompare.com API key</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <input placeholder="API key" id="openexchangerates_key" name="openexchangerates_key" type="text" class="validate" value="{{ @API.OPENEXCHANGERATES_APP_ID }}" required>
                <label for="openexchangerates_key">openexchangerates.org API key</label>
              </div>
            </div>
            <div class="row">
              <div class="input-field col s12 m6">
                <button class="waves-effect waves-light btn-large" type="submit">Next</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </check>
    <check if="{{ @vars.step==0 }}">
      <div class="row">
        <div class="col s12">
          <p>
            Market data for {{ @vars.updated_coins_count }} coins is successfully updated!
          </p>
          <p>
            The setup is now completed. In order to automatically pull new coins market data every hour please set up the following cron job:
          </p>
          <pre>0 * * * * wget -O - {{ @SCHEME.'://'.@HOST.@BASE }}/cron/{{ @SECURITY.TOKEN }} >/dev/null 2>&1</pre>
        </div>
      </div>
      <div class="row">
        <div class="col s12">
          <a href="{{ @BASE }}" class="waves-effect waves-light btn-large" target="_blank">Visit website</a>
          <a href="{{ @BASE }}{{ 'login' | alias }}" class="waves-effect waves-light btn-large" target="_blank">Log in to backend</a>
        </div>
      </div>
    </check>
  </section>
</section>