<!--Main content-->
<section id="content" class="container">

  <section id="coin-header">
    <div class="row">
      <div class="col s12 l7">
        <h1 class="primary-text">
          <img src="assets/images/coins/{{ @vars.coin.logo }}" alt="{{ @vars.coin.name }}" title="{{ @vars.coin.name }}">
          <span>{{ @vars.coin.name }}</span>
          <span>
            <check if="{{ @USER }}">
              <true>
                <button id="add-favorite-button" class="btn btn-floating white waves-effect waves-light tooltip {{ @vars.favorite ? 'hide' : '' }}" data-position="bottom" data-delay="10" data-tooltip="{{ @text.favorites_add }}"><i class="material-icons {{ @SITE.COLOR }}-text">star</i></button>
                <button id="remove-favorite-button" class="btn btn-floating {{ @SITE.COLOR }} waves-effect waves-light tooltip {{ @vars.favorite ? '' : 'hide' }}" data-position="bottom" data-delay="10" data-tooltip="{{ @text.favorites_remove }}"><i class="material-icons white-text">star</i></button>
              </true>
              <false>
                <a href="{{ @BASE }}{{ 'login' | alias }}?destination={{ urlencode(\Inc\Helper::uri()) }}" class="btn btn-floating white waves-effect waves-light tooltip" data-position="bottom" data-delay="10" data-tooltip="{{ @text.favorites_add }}"><i class="material-icons {{ @SITE.COLOR }}-text">star</i></a>
              </false>
            </check>
          </span>
        </h1>
      </div>
      <div class="col s12 l5 right-align">
        <div class="coin-price">
          <sup>{{ @vars.display_currency.code }}</sup><check if="{{ @vars.coin.symbol != 'BTC' }}"><true><span id="coin-price-value" class="tooltip" data-position="bottom" data-delay="100" data-tooltip="{{ @vars.coin.btc_price }} BTC"></true><false><span id="coin-price-value"></false></check>{{ @vars.coin.price }}</span>
        </div>
        <div>
          <span id="coin-abs-change-value" class="coin-abs-change {{ @vars.coin.raw_data.change > 0 ? 'change-up' : (@vars.coin.raw_data.change < 0 ? 'change-down' : '') }}">{{ @vars.coin.change }}</span>
          <span id="coin-pct-change-value" class="coin-pct-change {{ @vars.coin.raw_data.change > 0 ? 'change-up' : (@vars.coin.raw_data.change < 0 ? 'change-down' : '') }}">({{ @vars.coin.change_pct }})</span>
        </div>
      </div>
      <div class="col s12 center-align">
        <check if="{{ @SITE.COIN_BUY_LINK }}">
          <a href="{{ @SITE.COIN_BUY_LINK,@vars.coin.symbol | format }}" class="green waves-effect waves-light btn" target="_blank"><i class="material-icons left">arrow_upward</i>{{ @text.buy_coin,@vars.coin.symbol | format }}</a>
        </check>
        <check if="{{ @SITE.COIN_SELL_LINK }}">
          <a href="{{ @SITE.COIN_SELL_LINK,@vars.coin.symbol | format }}" class="red waves-effect waves-light btn" target="_blank"><i class="material-icons left">arrow_downward</i>{{ @text.sell_coin,@vars.coin.symbol | format }}</a>
        </check>
      </div>
    </div>
    <div class="row">
      <div class="col s12">
        <div class="divider"></div>
      </div>
    </div>
  </section>

  <!--Chart-->
  <section>
    <div class="row">
      <div class="col s12">
        <div id="coin-chart">
          <div id="coin-chart-preloader">
            <div class="preloader-wrapper small active">
              <div class="spinner-layer spinner-green-only">
                <div class="circle-clipper left">
                  <div class="circle"></div>
                </div>
                <div class="gap-patch">
                  <div class="circle"></div>
                </div>
                <div class="circle-clipper right">
                  <div class="circle"></div>
                </div>
              </div>
            </div>
          </div>
          <div id="coin-chart-comparison">
            <select id="select-comparison" multiple="multiple"></select>
          </div>
          <div id="coin-chart-container"></div>
        </div>
      </div>
    </div>
  </section>
  <!--END Chart-->

  <check if="{{ @SITE.COIN_TABS }}">
    <section>
      <div class="row">
        <div class="col s12 medium-vertical-margin">
          <ul class="tabs">
            <check if="{{ in_array('info', @SITE.COIN_TABS) && (@vars.coin.description || @vars.coin.features || @vars.coin.technology || @vars.coin.website) }}">
              <li class="tab"><a href="#info" class="active">{{ @text.info }}</a></li>
            </check>
            <check if="{{ in_array('key_indicators', @SITE.COIN_TABS) }}">
              <li class="tab"><a href="#key_indicators">{{ @text.key_indicators }}</a></li>
            </check>
            <check if="{{ in_array('trades', @SITE.COIN_TABS) }}">
              <li class="tab"><a href="#trades">{{ @text.trades }}</a></li>
            </check>
            <check if="{{ in_array('social', @SITE.COIN_TABS) }}">
              <li class="tab"><a href="#social">{{ @text.social }}</a></li>
            </check>
            <check if="{{ in_array('historical_data', @SITE.COIN_TABS) }}">
              <li class="tab"><a href="#historical_data">{{ @text.historical_data }}</a></li>
            </check>
            <check if="{{ in_array('widget', @SITE.COIN_TABS) }}">
              <li class="tab"><a href="#widget">{{ @text.widget }}</a></li>
            </check>
          </ul>
        </div>
        <check if="{{ in_array('info', @SITE.COIN_TABS) && (@vars.coin.description || @vars.coin.features || @vars.coin.technology || @vars.coin.website) }}">
          <div id="info">
          <check if="{{ @vars.coin.description }}">
            {{ @vars.coin.description | raw }}
          </check>
          <check if="{{ @vars.coin.features }}">
            {{ @vars.coin.features | raw }}
          </check>
          <check if="{{ @vars.coin.technology }}">
            {{ @vars.coin.technology | raw }}
          </check>
          <check if="{{ @vars.coin.website }}">
            <a href="{{ @vars.coin.website }}" class="waves-effect waves-light btn" target="_blank" rel="nofollow">
              {{ @text.visit_website }}
              <i class="material-icons right">open_in_new</i>
            </a>
          </check>
        </div>
        </check>
        <check if="{{ in_array('key_indicators', @SITE.COIN_TABS) }}">
          <div id="key_indicators" class="col s12">
          <table class="striped">
            <tbody>
              <tr>
                <td>{{ @text.market_share }}</td>
                <td class="right-align">{{ @vars.coin.market_share }}</td>
              </tr>
              <tr>
                <td>{{ @text.proof_type }}</td>
                <td class="right-align">{{ @vars.coin.proof_type ? @vars.coin.proof_type : '&mdash;' }}</td>
              </tr>
              <tr>
                <td>{{ @text.open }}</td>
                <td class="right-align"><sup>{{ @vars.display_currency.code }}</sup>{{ @vars.coin.open }}</td>
              </tr>
              <tr>
                <td>{{ @text.low }}</td>
                <td class="right-align"><sup>{{ @vars.display_currency.code }}</sup>{{ @vars.coin.low }}</td>
              </tr>
              <tr>
                <td>{{ @text.high }}</td>
                <td class="right-align"><sup>{{ @vars.display_currency.code }}</sup>{{ @vars.coin.high }}</td>
              </tr>
              <check if="{{ @vars.coin.symbol != 'BTC' }}">
                <tr>
                  <td>{{ @text.btc_price }}</td>
                  <td class="right-align">{{ @vars.coin.btc_price }} BTC</td>
                </tr>
              </check>
              <tr>
                <td>{{ @text.current_supply }}</td>
                <td class="right-align">{{ @vars.coin.supply }} {{ @vars.coin.symbol }}</td>
              </tr>
              <check if="{{ @vars.coin.total_supply }}">
                <tr>
                  <td>{{ @text.total_supply }}</td>
                  <td class="right-align">{{ @vars.coin.total_supply }} {{ @vars.coin.symbol }}</td>
                </tr>
              </check>
              <tr>
                <td>{{ @text.market_cap }}</td>
                <td class="right-align"><sup>{{ @vars.display_currency.code }}</sup>{{ @vars.coin.market_cap }}</td>
              </tr>
              <tr>
                <td>{{ @text.volume_coin }}</td>
                <td class="right-align">{{ @vars.coin.volume }} {{ @vars.coin.symbol }}</td>
              </tr>
              <tr>
                <td>{{ @text.volume_ccy }}</td>
                <td class="right-align"><sup>{{ @vars.display_currency.code }}</sup>{{ @vars.coin.volume_ccy }}</td>
              </tr>
              <tr>
                <td>{{ @text.total_volume_coin }}</td>
                <td class="right-align">{{ @vars.coin.total_volume }} {{ @vars.coin.symbol }}</td>
              </tr>
              <tr>
                <td>{{ @text.total_volume_ccy }}</td>
                <td class="right-align"><sup>{{ @vars.display_currency.code }}</sup>{{ @vars.coin.total_volume_ccy }}</td>
              </tr>
              <tr>
                <td>{{ @text.last_updated }}</td>
                <td class="right-align">{{ @vars.coin.last_updated }}</td>
              </tr>
            </tbody>
          </table>
        </div>
        </check>
        <check if="{{ in_array('trades', @SITE.COIN_TABS) }}">
          <div id="trades">
            <table class="bordered vertical-responsive-table">
              <thead>
              <tr>
                <th>{{ @text.id }}</th>
                <th>{{ @text.market }}</th>
                <th>{{ @text.type }}</th>
                <th class="right-align">{{ @text.price }}</th>
                <th class="right-align">{{ @text.quantity }}</th>
                <th class="right-align">{{ @text.total }}</th>
              </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </check>
        <check if="{{ in_array('social', @SITE.COIN_TABS) }}">
          <div id="social">
          <div class="col s12 m6">
            <div class="fb-comments" data-numposts="5" ></div>
          </div>
          <check if="{{ @vars.coin.twitter }}">
            <div id="twitter-timeline" class="col s12 m5 push-m1">
              <a class="twitter-timeline" href="https://twitter.com/{{ @vars.coin.twitter }}" data-chrome="noheader nofooter dark">{{ @text.tweets }}</a>
            </div>
          </check>
        </div>
        </check>
        <check if="{{ in_array('historical_data', @SITE.COIN_TABS) }}">
          <div id="historical_data">
          <table class="striped">
            <thead>
              <tr>
                <th>{{ @text.date }}</th>
                <th class="right-align">{{ @text.price }}</th>
                <th class="right-align">{{ @text.volume }}</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
        </check>
        <check if="{{ in_array('widget', @SITE.COIN_TABS) }}">
          <div id="widget">
            <div class="col s12">
              <p>{{ @text.widget_text,@vars.coin.name | format }}</p>
            </div>
            <div class="col s12 m6 l4">
              <iframe style="width: 100%; height: 180px;background:#fff;" frameBorder="0" scrolling="no" src="{{@SCHEME.'://'.@HOST.@BASE}}/widget?symbol={{ @vars.coin.symbol }}&currency={{ @vars.display_currency.symbol }}&demo=1"></iframe>
            </div>
            <div class="input-field col s12 m6 l8">
              <textarea id="widget-code" class="materialize-textarea" readonly="readonly">{{ htmlspecialchars('<iframe style="width: 100%; height: 180px" frameBorder="0" scrolling="no" src="'.@SCHEME.'://'.@HOST.@BASE.'/widget?symbol='.@vars.coin.symbol.'&currency='.@vars.display_currency.symbol.'"></iframe>') }}</textarea>
              <label for="widget-code">{{ @text.widget_code }}</label>
              <div class="right-align">
                <button id="copy-widget-code-button" class="{{ @SITE.COLOR }} waves-effect waves-light btn"><i class="material-icons left">content_copy</i> {{ @text.widget_copy }}</button>
              </div>
            </div>
          </div>

        </check>
      </div>
    </section>
  </check>
</section>
<!--END Main content-->
