<!--Main content-->
<section id="content" class="container">
  <check if="{{ @SITE.RSS_URL }}">
    <!--News ticker-->
    <section id="news-ticker">
      <div class="row">
        <div class="col s12 m4 l2">
          <div class="primary-background center">
            {{ @text.breaking_news }}
          </div>
        </div>
        <div class="col s12 m8 l10">
          <span id="news-ticker-typed"></span>
        </div>
      </div>
    </section>
  <!--END News ticker-->
  </check>

  <!--Coins table-->
  <set sort_order="{{ @GET.sort ? @GET.sort : @SITE.COINS_SORT }}" />
  <set sort_direction="{{ @GET.dir ? @GET.dir : @SITE.COINS_DIR }}" />
  <set featured="{{ @GET.featured ? @GET.featured : 0 }}" />

  <section id="coins-table">
    <div class="row">
      <div class="col s12 center-align">
        <span class="switch">
          <label>
            <input id="switch-featured" type="checkbox" {{ @GET.featured ? 'checked' : '' }}>
            <span class="lever"></span>
            {{ @text.featured_coin }}
          </label>
        </span>
      </div>
    </div>
    <div class="row">
      <div class="col s12">
        <table id="coins-list" class="bordered highlight vertical-responsive-table">
          <thead>
            <tr>
              <th><a href="{{ @BASE }}?featured={{ @featured }}&sort=name&dir={{ @sort_direction=='ASC'?'DESC':'ASC' }}">{{ @sort_order=='name'?'<i class="material-icons">'.(@sort_direction=='ASC'?'arrow_drop_up':'arrow_drop_down').'</i>':'' }} {{ @text.cryptocurrency }}</a></th>
              <repeat group="{{ @SITE.COINS_FIELDS }}" value="{{ @field }}">
                <th class="right-align">
                  <check if="{{ @field != 'intraday_quotes' }}">
                    <true>
                      <a href="{{ @BASE }}?featured={{ @featured }}&sort={{ @field }}&dir={{ @sort_direction=='ASC'?'DESC':'ASC' }}">
                        <check if="{{ @sort_order==@field }}">
                          <i class="material-icons">{{ @sort_direction=='ASC' ? 'arrow_drop_up' : 'arrow_drop_down' }}</i>
                        </check>
                        {{ @text[@field] }}
                      </a>
                    </true>
                    <false>
                      <a href="#!">{{ @text[@field] }}</a>
                    </false>
                  </check>
                </th>
              </repeat>
            </tr>
          </thead>
          <tbody>
          <repeat group="{{ @vars.coins }}" key="{{ @i }}" value="{{ @coin }}">
            <tr class="{{ @coin.featured ? 'featured' : '' }} {{ @coin.ws_disabled==1 ? 'ws-disabled' : '' }} coin-row coin-row-{{ @coin.symbol }}" data-symbol="{{ @coin.symbol }}">
              <td data-title="{{ @text.cryptocurrency }}">
                <span class="coin-number">{{ @i+1 }}</span>
                <a href="{{ @BASE }}{{ 'coin','symbol='.@coin.coin_page_key | alias }}">
                  <img src="assets/images/coins/thumb30/{{ @coin.logo }}" alt="{{ @coin.name }}" title="{{ @coin.name }}">
                </a>
                <span><a href="{{ @BASE }}{{ 'coin','symbol='.@coin.coin_page_key | alias }}">{{ @coin.name }}</a></span>
                <check if="{{ @coin.featured }}">
                  <span data-badge-caption="{{ @text.featured }}" class="new {{ @SITE.COLOR }} badge"></span>
                </check>
              </td>
              <repeat group="{{ @SITE.COINS_FIELDS }}" value="{{ @field }}">
                <check if="{{ in_array(@field, ['price','open','low','high','market_cap','volume_ccy','total_volume_ccy']) }}">
                  <td class="right-align" data-title="{{ @text[@field] }}"><sup>{{ @vars.display_currency.code }}</sup><span class="coin-{{ @field }}-value">{{ @coin[@field] }}</span></td>
                </check>
                <check if="{{ in_array(@field, ['supply','volume','total_volume']) }}">
                  <td class="right-align" data-title="{{ @text[@field] }}"><span class="coin-{{ @field }}-value">{{ @coin[@field] }}</span> {{ @coin.symbol }}</td>
                </check>
                <check if="{{ in_array(@field, ['change','change_pct']) }}">
                  <td class="right-align" data-title="{{ @text[@field] }}">
                    <span class="coin-{{ @field }}-value {{ @coin.raw_data[@field] > 0 ? 'change-up' : (@coin.raw_data[@field] < 0 ? 'change-down' : '') }}">{{ @coin[@field] }}</span>
                </td>
                </check>
                <check if="{{ @field == 'intraday_quotes' }}">
                  <td class="performance-sparkline right-align" data-title="{{ @text[@field] }}">
                    <check if="{{ @coin.intraday_quotes && isset(@coin.intraday_quotes['p']) }}">
                      <span values="{{ implode(',',@coin.intraday_quotes['p']) }}"></span>
                    </check>
                  </td>
                </check>
                <check if="{{ @field == 'last_updated' }}">
                  <td class="right-align" data-title="{{ @text[@field] }}">{{ @coin.last_updated }}</td>
                </check>
              </repeat>
            </tr>
          </repeat>
          </tbody>
        </table>
      </div>
    </div>
    <div class="row">
      <div class="col s12 center-align">
        <button id="load-more-coins" class="waves-effect waves-light btn-large"><i class="material-icons left">cloud_download</i>{{ @text.load_more }}</button>
      </div>
    </div>
  </section>
  <!--END Coins table-->
</section>
<!--END Main content-->