<!--Side menu-->

<ul id="side-menu" class="side-nav">
  <li><a class="subheader">{{ @site.name }}</a></li>
  <li><a href="{{ @BASE }}" class="waves-effect"><i class="material-icons">public</i>{{ @text.front_page }}</a></li>
  <li><a href="{{ @BASE }}/risers" class="waves-effect"><i class="material-icons">trending_up</i>{{ @text.top_risers }}</a></li>
  <li><a href="{{ @BASE }}/fallers" class="waves-effect"><i class="material-icons">trending_down</i>{{ @text.top_fallers }}</a></li>
  <li><a href="{{ @BASE }}/favorites" class="waves-effect"><i class="material-icons">star_border</i>{{ @text.favorites }}</a></li>
  <li><a href="{{ @BASE }}/calculator" class="waves-effect"><i class="material-icons">compare_arrows</i>{{ @text.calculator }}</a></li>
  <li><a href="{{ @BASE }}/page/faq" class="waves-effect"><i class="material-icons">help_outline</i>{{ @text.faq_header }}</a></li>
  
  
  <li class="btn-side-menu-languages-container">
    <a href="#" id="btn-side-menu-languages" data-activates="side-menu-languages" class="waves-effect">
      <i class="material-icons">translate</i>
      <span>
      <img class="right mn-lang-img" alt="" src="assets/images/flags/{{ strtolower(substr(@vars.display_language, -2)) }}.png"> 
      {{ @text.side_menu_language }}
      </span>
    </a>
  </li>
  
  <li class="btn-side-menu-currency-container">
    <a href="#" id="btn-side-menu-currency" data-activates="side-menu-currency" class="waves-effect">
      <i class="material-icons">attach_money</i>
      <span>
      <span class="right mn-currency-val">{{ @vars.display_currency.symbol }}</span>
      {{ @text.side_menu_currency }}
      </span>
    </a>
  </li>
  
  <li class="btn-side-menu-currency-container"><a href="#" id="theme-change-button" class="waves-effect"><i class="material-icons">brightness_medium</i>{{ @text.theme_change }}</a></li>
  
  <check if="{{ @USER.admin }}">
    <li><div class="divider"></div></li>
    <li><a class="subheader">{{ @text.backend }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_settings' | alias }}" class="waves-effect"><i class="material-icons">settings</i>{{ @text.settings }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_banners' | alias }}" class="waves-effect"><i class="material-icons">drag_handle</i>{{ @text.banners }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_coins' | alias }}" class="waves-effect"><i class="material-icons">view_list</i>{{ @text.coins_management }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_download' | alias }}" class="waves-effect"><i class="material-icons">cloud_download</i>{{ @text.download_coins }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_strings' | alias }}" class="waves-effect"><i class="material-icons">translate</i>{{ @text.strings_overrides }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_cron' | alias }}" class="waves-effect"><i class="material-icons">loop</i>{{ @text.cron }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_logs' | alias }}" class="waves-effect"><i class="material-icons">format_align_left</i>{{ @text.logs }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_update' | alias }}" class="waves-effect"><i class="material-icons">refresh</i>{{ @text.update_config }}</a></li>
    <li><a href="{{ @BASE }}{{ 'backend_help' | alias }}" class="waves-effect"><i class="material-icons">help_outline</i>{{ @text.help }}</a></li>
  </check>
  <check if="{{ @USER }}">
    <true>
      <li><a href="{{ @BASE }}{{ 'logout' | alias }}" class="waves-effect"><i class="material-icons">lock</i>{{ @text.logout }}</a></li>
    </true>
    <false>
      <li><a href="{{ @BASE }}{{ 'login' | alias }}" class="waves-effect"><i class="material-icons">lock_open</i>{{ @text.login }}</a></li>
    </false>
  </check>
</ul>

<ul id="side-menu-languages" class="side-nav">
  
  
  <li><a class="waves-effect">
    <i class="material-icons">translate</i>
      <span>
      <img class="right mn-lang-img" alt="" src="assets/images/flags/{{ strtolower(substr(@vars.display_language, -2)) }}.png"> 
      {{ @text.side_menu_language }}
      </span>
  </a></li>
  
  <repeat group="{{ @vars.languages_list }}" key="{{ @language }}" value="{{ @language_name }}">
	  <set country="{{ strtolower(substr(@language, -2)) }}" />
    <li><a href="#" data-lang="{{ @language }}" class="mn-side-lang-select waves-effect"><img src="assets/images/flags/{{ @country }}.png"> {{ @language_name }}</a></li>
	</repeat>
</ul>

<ul id="side-menu-currency" class="side-nav">
  
  
  <li><a class="waves-effect">
    <i class="material-icons">attach_money</i>
    <span>
    <span class="right mn-currency-val">{{ @vars.display_currency.symbol }}</span>
    {{ @text.side_menu_currency }}
    </span>
  </a></li>
  
  <li>
      <input type="text" placeholder="{{ @text.side_menu_currency_placeholder}}" class="mn-side-finder">
  </li>
  <repeat group="{{ @vars.currencies_list }}" key="{{ @symbol }}" value="{{ @ccy }}">
		<li class="finder-item"><a href="#" data-currency="{{ @symbol }}" class="mn-side-currency-select waves-effect"> {{ @ccy['name'] }}</a></li>
	</repeat>
</ul>


<!--END Side menu-->