<?php
namespace View;
use Inc\Helper;

/**
 * Class Formatter - format data before displaying
 * @package View
 */
class Formatter {
  /**
   * Formatter for coin data on individual coin page
   * @param $data
   * @return mixed
   */
  public function formatterCoin($data) {
    if (!empty($data)) $data['raw_data'] = $data;

    if (isset($data['price'])) $data['price'] = $this->decimal($data['price']);
    if (isset($data['open'])) $data['open'] = $this->decimal($data['open']);
    if (isset($data['low'])) $data['low'] = $this->decimal($data['low']);
    if (isset($data['high'])) $data['high'] = $this->decimal($data['high']);
    if (isset($data['change'])) $data['change'] = $this->decimal($data['change']);
    if (isset($data['change_pct'])) $data['change_pct'] = $this->decimalPercent($data['change_pct']);
    if (isset($data['supply'])) $data['supply'] = $this->integer($data['supply']);
    if (isset($data['total_supply'])) $data['total_supply'] = $this->integer($data['total_supply']);
    if (isset($data['volume'])) $data['volume'] = $this->integer($data['volume']);
    if (isset($data['volume_ccy'])) $data['volume_ccy'] = $this->integer($data['volume_ccy']);
    if (isset($data['total_volume'])) $data['total_volume'] = $this->integer($data['total_volume']);
    if (isset($data['total_volume_ccy'])) $data['total_volume_ccy'] = $this->bigNumber($data['total_volume_ccy']);
    if (isset($data['market_cap'])) $data['market_cap'] = $this->integer($data['market_cap']);
    if (isset($data['market_share'])) $data['market_share'] = $this->decimalPercent($data['market_share']);
    return $data;
  }

  /**
   * Formatter for coins list on index page
   * @param $data
   * @return mixed
   */
  public function formatterCoins($items) {
    foreach ($items as $i => $data) {
      $data['raw_data'] = $data;

      if (isset($data['price'])) $data['price'] = $this->decimal($data['price']);
      if (isset($data['open'])) $data['open'] = $this->decimal($data['open']);
      if (isset($data['low'])) $data['low'] = $this->decimal($data['low']);
      if (isset($data['high'])) $data['high'] = $this->decimal($data['high']);
      if (isset($data['change'])) $data['change'] = $this->decimal($data['change']);
      if (isset($data['change_pct'])) $data['change_pct'] = $this->decimalPercent($data['change_pct']);
      if (isset($data['supply'])) $data['supply'] = $this->integer($data['supply']);
      if (isset($data['volume'])) $data['volume'] = $this->decimal($data['volume']);
      if (isset($data['volume_ccy'])) $data['volume_ccy'] = $this->decimal($data['volume_ccy']);
      if (isset($data['total_volume'])) $data['total_volume'] = $this->integer($data['total_volume']);
      if (isset($data['total_volume_ccy'])) $data['total_volume_ccy'] = $this->bigNumber($data['total_volume_ccy']);
      if (isset($data['market_cap'])) $data['market_cap'] = $this->bigNumber($data['market_cap']);

      $items[$i] = $data;
    }
    return $items;
  }

  /**
   * Formatter for stats data
   * @param $data
   * @return mixed
   */
  public function formatterCoinsOverallStats($data) {
    $data['total_volume'] = $this->bigNumber($data['total_volume']);
    $data['total_market_cap'] = $this->bigNumber($data['total_market_cap']);
    return $data;
  }

  public function formatterRisers($items) {
    foreach ($items as &$data) {
      $data['change_pct'] = $this->decimalPercent($data['change_pct']);
    }
    return $items;
  }

  public function formatterFallers($items) {
    foreach ($items as &$data) {
      $data['change_pct'] = $this->decimalPercent($data['change_pct']);
    }
    return $items;
  }

  private function integer($number) {
    return Helper::formatNumber($number, 0);
  }

  private function decimal($number) {
    return Helper::formatNumber($number, 'auto');
  }

  private function decimalPercent($number) {
    return Helper::formatNumber($number, 2, '', '%');
  }

  private function bigNumber($number) {
    $f3 = \Base::instance();

    $suffixes = [1 => '', 1000 => 'K', 1000000 => 'M', 1000000000 => 'B'];
    if ($number > 1000000000) {
      $n = 1000000000;
    } elseif ($number > 1000000) {
      $n = 1000000;
    } elseif ($number > 1000) {
      $n = 1000;
    } else {
      $n = 1;
    }

    return $this->decimal($number /$n) . $f3->get('text.short_number_format')[$suffixes[$n]];
  }
}