"use strict";
$(document).ready(function() {
  $('#backend-menu-button').sideNav();
  $('.collapsible').collapsible();
  $('.materialize-select').material_select();
  $('.tooltip').tooltip();

  if (typeof MESSAGES != 'undefined') {
    var messagesCount = MESSAGES.length;
    for (var i = 0; i < messagesCount; i++) {
      Materialize.toast(MESSAGES[i].text, 5000);
    }
  }

  // disable buttons on click
  $('.btn-large[type="submit"]').on('click', function () {
    var $button = $(this);
    $button.addClass('disabled');
  });

  // search coins on click
  $('#search-coins-button').on('click', function() {
    var $input = $(this).parent().find('input');
    searchCoin($input.val());
  });

  // search coins on enter
  $('#search-coins-input').keypress(function (e) {
    if (e.which == 13) {
      searchCoin($(this).val());
    }
  });

  $('#strings-language').on('change', function () {
    $(this).closest('form').submit();
  });

  if (typeof tinymce != 'undefined') {
    tinymce.init({
      selector: '.tinymce-field textarea',
      theme: 'modern',
      branding: false,
      menubar: false,
      height : 200,
      plugins: [
        'advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker',
        'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking',
        'save table contextmenu directionality template paste textcolor'
      ],
      extended_valid_elements: 'script[charset|defer|language|src|type|async]',
      toolbar: 'insertfile undo redo removeformat | formatselect fontsizeselect alignleft aligncenter alignright alignjustify | bold italic underline strikethrough blockquote | bullist numlist | link image | forecolor backcolor | code | table'
    });
  }

  function searchCoin(search) {
    window.location = location.pathname + '?search=' + search;
  }
});