"use strict";
$(document).ready(function() {
  var $amount           = $('#amount');
  var $coinFrom         = $('#convert-from');
  var $coinTo           = $('#convert-to');
  var $resultAmountFrom = $('#result-amount-from');
  var $resultAmountTo   = $('#result-amount-to');
  var $resultSymbolFrom = $('#result-symbol-from');
  var $resultSymbolTo   = $('#result-symbol-to');

  convert();

  $('#calculator-swap-button').on('click', function () {
    var coinFrom  = $coinFrom.select2('data')[0];
    var coinTo    = $coinTo.select2('data')[0];

    $amount.val($resultAmountTo.text());

    // the below causes convert() to be called twice, however this is the only way for now
    $coinFrom.select2('trigger', 'select', {
      data: { id: coinTo.id, text: coinTo.text }
    });

    $coinTo.select2('trigger', 'select', {
      data: { id: coinFrom.id, text: coinFrom.text }
    });
  });

  $amount.on('keyup input', function () {
    convert();
  });

  $coinFrom
    .select2({
      containerCssClass: 'select2-selection-convert',
      dropdownCssClass: 'select2-dropdown-convert',
      width: '100%',
      language: TEXT.select2,
      minimumInputLength: 1
    })
    .on('change', function() {
      $resultSymbolFrom.text($(this).val());
      convert();
    });

  $coinTo
    .select2({
      containerCssClass: 'select2-selection-convert',
      dropdownCssClass: 'select2-dropdown-convert',
      width: '100%',
      language: TEXT.select2,
      minimumInputLength: 1
    })
    .on('change', function() {
      $resultSymbolTo.text($(this).val());
      convert();
    });


  function convert() {
    var result;
    var coinFrom    = $coinFrom.val();
    var coinTo      = $coinTo.val();
    var amount      = parseFloat($amount.val());

    if (isNaN(amount)) {
      amount = 0;
      result = 0;
    } else if (coinFrom == coinTo) {
      result = amount;
    } else {
      var quote1 = typeof COINS_QUOTES[coinFrom] != 'undefined' ? (COINS_QUOTES[coinFrom].type == 'cryptocurrency' ? COINS_QUOTES[coinFrom].quote : 1/COINS_QUOTES[coinFrom].quote) : 0;
      var quote2 = typeof COINS_QUOTES[coinTo] != 'undefined' ? (COINS_QUOTES[coinTo].type == 'cryptocurrency' ? 1/COINS_QUOTES[coinTo].quote : COINS_QUOTES[coinTo].quote) : 0;
      result = amount * quote1 * quote2;
    }

    $resultAmountFrom.text(amount);
    $resultAmountTo.text(result);
  }
});