"use strict";
$(document).ready(function() {
  var $searchCoinsSelect = $('#search-coins');
  var screenWidth = (window.innerWidth > 0) ? window.innerWidth : screen.width;

  numeral.register('locale', 'custom', {
    delimiters: {
      thousands: THOUSANDS_SEPARATOR,
      decimal: DECIMAL_POINT
    },
    abbreviations: {
      thousand: 'k',
      million: 'm',
      billion: 'b',
      trillion: 't'
    },
    ordinal : function (number) {
      return '';
    },
    currency: {
      symbol: DISPLAY_CURRENCY ? DISPLAY_CURRENCY.code : ''
    }
  });
  numeral.locale('custom');

  // destroy datatable
  $.fn.destroyDataTable = function() {
    if (this.hasClass('dataTable')) {
      this.DataTable().destroy();
    }
  };

  // datatable initialization and re-initialization
  $.fn.initDataTable = function(rowsPerPage, order, searchEnabled, footerCallback, footerCallbackArguments, buttons) {
    rowsPerPage = rowsPerPage || 15;
    order = order || [];
    searchEnabled = searchEnabled || false;
    footerCallback = footerCallback || function () {};
    buttons = buttons || false;
    var $self = this;
    var table;
    var displayStart = 0;
    // if table exist retrieve its current order and page
    if ($self.hasClass('dataTable')) {
      table = $self.DataTable();
      var info = table.page.info();
      var order = table.order();
      displayStart = info.page;
      order = [[order[0][0], order[0][1]]];
      table.destroy();
    }

    table = $self.DataTable({
      bLengthChange: false,
      pageLength: rowsPerPage,
      displayStart: displayStart * rowsPerPage,
      bFilter: searchEnabled,
      oLanguage: TEXT.datatables,
      order: order,
      info: false, // hide "Showing 1 to K of N Entries"
      footerCallback: function () {
        if (typeof footerCallbackArguments != 'undefined') {
          var extendedArguments = Array.prototype.slice.call(arguments);
          extendedArguments.push(footerCallbackArguments);
          footerCallback.apply(this, extendedArguments);
        } else {
          footerCallback.apply(this);
        }
      },
      initComplete: function(settings, json) {
        if (!$self.is(':visible')) {
          $self.show();
        }
      },
      dom: 'Bfrtip',
      buttons: buttons
    });

    if (searchEnabled) {
      $self.closest('.dataTables_wrapper').find('.dataTables_filter').addClass('ui icon small input').append('<i class="search icon"></i>');
    }

    if (buttons) {
      $self.closest('.dataTables_wrapper').find('.buttons-csv').addClass('ui basic icon button').prepend('<i class="file excel outline icon"></i> ');
    }

    return table;
  };

  if (typeof $.fn.select2 != 'undefined') {
    $.fn.initCoinsSearchAutocomplete = function (placeholder, width) {
      return this.select2({
        placeholder: placeholder,
        width: width || '100%',
        containerCssClass: 'select2-selection-' + this.attr('id'),
        dropdownCssClass: 'select2-dropdown-' + this.attr('id'),
        ajax: {
          url: function (params) {
            return API.coinsSearch + '/' + params.term;
          },
          dataType: 'json',
          delay: 250,
          processResults: function (data, params) {
            log('autocomplete', data);
            params.page = params.page || 1;
            return {
              results: data.search
            };
          },
          cache: true
        },
        language: TEXT.select2,
        escapeMarkup: function (markup) {
          return markup;
        },
        minimumInputLength: 2,
        templateResult: function (item) {
          if (item.loading) return item.name;

          return '<div class="symbol-search-row">' +
            '<img src="assets/images/coins/thumb30/' + item.logo + '">' +
            '<span class="symbol-search-name">' + item.name + '</span>' +
            '<span class="symbol-search-symbol">' + item.symbol + '</span>' +
            '</div>';
        },
        templateSelection: function (item) {
          return item.name || item.text || item.id;
        }
        // remove option tags when they are deselected, otherwise they will stick to the same place when added again
      }).on('select2:unselect', function (event) {
        if (typeof event.params.data.id != 'undefined') {
          $(this).find('option[value="' + event.params.data.id + '"]').remove();
        }
      });
    };
  }

  if (typeof $.fn.sparkline != 'undefined') {
    $.fn.displaySparklineCharts = function () {
      return this
        .sparkline(
          'html', {
            type: 'line',
            lineColor: COLOR_CODE,
            fillColor: false,
            minSpotColor: false,
            maxSpotColor: false,
            spotColor: COLOR_CODE,
            highlightSpotColor: COLOR_CODE,
            spotRadius: 0,
            height: '2rem',
            width: '10rem',
            numberDigitGroupSep: THOUSANDS_SEPARATOR,
            numberDecimalMark: DECIMAL_POINT
          })
        .addClass('sparkline-added');
    };
  }

  $('#menu-button').sideNav();
  // add cookie consent popup
  if (typeof Cookies != 'undefined') {
    if (REQUIRE_COOKIE_ACCEPTANCE && typeof Cookies.get('cookie_policy') == 'undefined') {
      setTimeout(function () {
        $('#cookie-notice').removeClass('scale-out').addClass('scale-in');
      }, 1000);
      $('#accept-cookies-usage').on('click', function () {
        Cookies.set('cookie_policy', 'accept', {expires: 365});
        $('#cookie-notice').removeClass('scale-in').addClass('scale-out');
      });
    }
  }

  if ($searchCoinsSelect.length) {
    $searchCoinsSelect.initCoinsSearchAutocomplete(null, (screenWidth >= 500 ? 300 : screenWidth * 0.4) + 'px');

    $searchCoinsSelect
    // set opacity back to 0 before input is disappeared
      .on('select2:closing', function (e) {
        $('.select2-dropdown-search-coins').css({opacity: 0});
      })
      // redirect to coin page when a specific coin is selected
      .on('change', function () {
        var $select = $(this);
        var symbol = $select.val();
        window.location.href = COIN_PAGE_SLUG + symbol;
      });
  }

  $('.button-collapse').sideNav();
  $('.dropdown-button').dropdown();
  $('ul.tabs').tabs(/*{ swipeable: true }*/);
  $('.modal').modal();

  $('#search-coins-button').on('click', function () {
    $searchCoinsSelect.select2('open');
    $('.select2-dropdown-search-coins').animate({opacity: 1});
  });

  // copy donation adddress to clipboard
  $('.copy-address-button').on('click', function () {
    var $input = $(this).closest('.row').find('input').select();
    $input.copyToClipboard();
  });

  $.fn.copyToClipboard = function() {
    // select content, so it can be copied
    this.select();
    try {
      document.execCommand('copy');
    } catch (err) {
      log('Copy to clipboard is not supported');
    }
    // clear selection
    document.getSelection().removeAllRanges();

    return this;
  };

  // style datatables buttons
  if (typeof $.fn.dataTable != 'undefined') {
    $.fn.dataTable.ext.classes.sPageButton = 'waves-effect btn btn-small';
  }

  if (typeof $.fn.select2 != 'undefined') {
  $('select#currency-select').select2({
    containerCssClass:'currency-selector',
    dropdownCssClass : 'currency-drop',
    theme: 'mn-header-selector',
    width:'70px',
    templateSelection:function (state) {
      if (!state.id) {
        return state.text;
      }

      return state.id;
    }
  });
  $('select#currency-select').change(function(){
    var currency = $(this).val();
    $('<form method="POST" action="'+BASE_PATH+'/">' +
      '<input type="hidden" name="currency" value="'+currency+'">' +
      '<input type="hidden" name="path" value="'+PATH+'">' +
      '</form>'
    ).appendTo('body').submit();
  });

  $('select#language-select').select2({
    containerCssClass:'language-selector',
    dropdownCssClass : 'language-drop',
    theme: 'mn-header-selector',

    width:'56px',
    templateResult:function (state) {
      if (!state.id) {
        return state.text;
      }
      var flag_uri = $(state.element).data('flag');
      var $state = $(
        '<span><img src="' + flag_uri + '" class="" /> ' + state.text + ' </span>'
      );


      return $state;
    },
    templateSelection:function (state) {
      if (!state.id) {
        return state.text;
      }
      var flag_uri = $(state.element).data('flag');
      var $state = $(
        '<span><img src="' + flag_uri + '" class="" /> </span>'
      );
      return $state;
    }
  });
  $('select#language-select').change(function(){
    var language = $(this).val();
    $('<form method="POST" action="'+BASE_PATH+'/">' +
      ' <input type="hidden" name="language" value="'+language+'">' +
      ' <input type="hidden" name="path" value="'+PATH+'">' +
      '</form>'
    ).appendTo('body').submit();
  });

  $('#btn-side-menu-languages').sideNav();
  $('.mn-side-lang-select').click(function(){
    var language = $(this).data('lang');
    $('<form method="POST" action="'+BASE_PATH+'/">' +
      ' <input type="hidden" name="language" value="'+language+'">' +
      ' <input type="hidden" name="path" value="'+PATH+'">' +
      '</form>'
    ).appendTo('body').submit();
  });
  $('#btn-side-menu-currency').sideNav();
  $('.mn-side-finder').keyup(function(){
    var me=$(this);
    var t = me.data('t');
    var s = me.val().toLowerCase();
    if(t)clearTimeout(t);
    t=setTimeout(function(){
      var c=me.closest('.side-nav');
      c.find('.finder-item').each(function(){
        var k=$(this);
        if(!s.length)k.show();
        else if($(this).text().toLowerCase().indexOf(s)==-1)k.hide();
        else k.show();
      });
      me.data('t',undefined);
    },250);
    me.data('t',t);

  });
  $('.mn-side-currency-select').click(function(){
    var currency = $(this).data('currency');
    $('<form method="POST" action="'+BASE_PATH+'/">' +
      '<input type="hidden" name="currency" value="'+currency+'">' +
      '<input type="hidden" name="path" value="'+PATH+'">' +
      '</form>'
    ).appendTo('body').submit();
  });


  $('a#theme-change-button').click(function(e){
    var $body = $('body');
    if($body.hasClass('black-theme') ){
      Cookies.remove('black_theme');
      $body.removeClass('black-theme');
      if(typeof(window.reinitChart)=='function')window.reinitChart();
    } else {
      Cookies.set('black_theme', '1', {expires: 365});
      $body.addClass('black-theme');
      if(typeof(window.reinitChart)=='function')window.reinitChart();
    }

    e.stopPropagation();
    return false;
  });
  }
});

function RealTimeDataFeed(options) {
  //var SUBSCRIPTION_STRING = '5~CCCAGG~{0}';
  var url = 'wss://streamer.cryptocompare.com/v2?api_key=' + CRYPTOCOMPARE_API_KEY;

  var subs = options.subs || '';
  //var assets = [];
  var ws;

  if (subs) {
    connect();
  }

  /**
   * Establish SOCKET connection
   */
  function connect() {
    if (!connected()) {
      log('Making WS connection to ' + url);
      ws = new WebSocket(url);
      ws.onopen = onConnect;
      ws.onmessage = onMessage;
      ws.onclose = onDisconnect;
      // ws.onerror = onError;
    } else {
      log('WS connection already established');
    }
  }

  function connected() {
    return ws && ws.readyState === WebSocket.OPEN;
  }

  /**
   * SOCKET connection is established
   */
  function onConnect() {
    log('WS connection OPEN');
    if (typeof options.onConnect == 'function') {
      options.onConnect();
    }

    subscribe(options.subs);
  }

  /**
   * SOCKET message is received
   * @param event
   */
  function onMessage(event) {
    var message = JSON.parse(event.data);
    var type = parseInt(message.TYPE, 10);

    // Trade data
    if (type === 0) {
      // log('TRADE', message);

      if (typeof message['F'] != 'undefined' && message['F'] & 1) {
        message['TYPE'] = 'buy';
      } else if (typeof message['F'] != 'undefined' && message['F'] & 2) {
        message['TYPE'] = 'sell';
      }

      if (typeof options.onTrade == 'function') {
        options.onTrade(message);
      }
      // Aggregate data
    } else if (type === 5) {
      // log('QUOTE', message);
      if (typeof options.onAggQuote == 'function') {
        options.onAggQuote(message);
      }
    }
  }

  /**
   * SOCKET connection is closed
   */
  function onDisconnect() {
    log('WS connection CLOSED');
    //connect();
  }

  function subscribe(subs) {
    log('WS subscribe', subs);

    ws.send(JSON.stringify({
      action: 'SubAdd',
      subs: subs
    }));
  }

  return {
    subscribe: subscribe
  }
}

function log() {
  if (DEBUG) {
    console.log('CMC', arguments);
  }
}

/**
 * Delete value from array
 * @param array
 * @param value
 */
function deleteFromArray(array, value) {
  var n = array.length;
  for (var i=0; i<n; i++) {
    if (array[i] == value) {
      array.splice(i, 1);
      break;
    }
  }
}

function formatDecimal(number) {
  if (typeof numeral != 'undefined') {
    var format;
    var num = numeral(number);
    var n = Math.abs(num.value());
    if (n > 0.01) {
      format = '0,0.00';
    } else if (0.0001 < n && n < 0.01) {
      format = '0.0000';
    } else if (0.000001 < n && n < 0.0001) {
      format = '0.000000';
    } else if (n < 0.000001) {
      format = '0.00000000';
    }
    var formatted = num.format(format);
    return formatted!=='NaN' ? formatted : parseFloat(number).toFixed(8);
  }
  return number;
}

function formatPercentage(number) {
  if (typeof numeral != 'undefined') {
    var format;
    var num = numeral(number);
    var n = Math.abs(num.value()) * 100;
    if (n > 0.01) {
      format = '0,0.00%';
    } else if (0.0001 < n && n < 0.01) {
      format = '0.0000%';
    } else if (0.000001 < n && n < 0.0001) {
      format = '0.000000%';
    } else if (n < 0.000001) {
      format = '0.00000000%';
    }
    var formatted = num.format(format);
    return formatted!=='NaN' ? formatted : parseFloat(number).toFixed(2);
  }
  return number;
}

function handleAjaxError(jqXHR, textStatus, errorThrown) {
  console.error('handleAjaxError', textStatus+'|'+errorThrown);
}

/**
 * Subtract one array from another and return difference
 * [1,2,3,4,5,6].subtract( [3,4,5] ) => [1, 2, 6]
 * @param subtractedArray
 * @returns {Array.<T>}
 */
Array.prototype.subtract = function(subtractedArray) {
  return this.filter(function(element) {return subtractedArray.indexOf(element) < 0;});
};
