"use strict";
$(document).ready(function() {
  var offset = COINS_LIMIT;
  var $tableCoins = $('#coins-list');
  var realTimeDataFeed;
  var marketData = {};

  $('#load-more-coins').on('click', function() {
    $.ajax({
      url: API.coinsData + '/' + COINS_SORT + '/' + COINS_DIR + '/' + offset + '/' + COINS_FEATURED,
      dataType: 'json',
      async: true,
      cache: false,
      success: displayCoins,
      error: handleAjaxError
    });
  });

  if (COINS_REALTIME_FEED)
    initRealTimeFeed();

  function displayCoins(response) {
    log('displayCoins', response);
    if (typeof response.coins != 'undefined') {
      var subs = [];
      $.each(response.coins, function (i, coin) {
        var row = '<tr class="' + (coin.featured ? 'featured' : '') + ' ' + (coin.ws_disabled==1 ? 'ws-disabled' : '') + '">' +
          ' <td data-title="'+TEXT.cryptocurrency+'">' +
          '   <span class="coin-number">' + (i + 1 + offset) + '</span>' +
          (coin.logo ? '<a href="' + COIN_PAGE_SLUG + coin.coin_page_key + '"><img src="assets/images/coins/' + coin.logo + '" alt="' + coin.name + '" title="' + coin.name + '"></a>' : '') +
          '   <a href="' + COIN_PAGE_SLUG + coin.coin_page_key + '"><span>' + coin.name + '</span></a>' +
          (coin.featured ? '<span data-badge-caption="'+TEXT.featured+'" class="new '+COLOR+' badge"></span>' : '')
        ' </td>';
        for (var i=0; i<COINS_FIELDS.length; i++) {
          var field = COINS_FIELDS[i];
          if (['price','open','low','high','market_cap','volume_ccy','total_volume_ccy'].indexOf(field) !== -1) {
            row += '<td class="right-align" data-title="'+TEXT[field]+'"><sup>'+DISPLAY_CURRENCY.code+'</sup>'+coin[field]+'</td>';
          } else if (['supply','volume','total_volume'].indexOf(field) !== -1) {
            row += '<td class="right-align" data-title="'+TEXT[field]+'">'+coin[field]+' '+coin.symbol+'</td>';
          } else if (['change','change_pct'].indexOf(field) !== -1) {
            row += '<td class="right-align" data-title="'+TEXT[field]+'"><span class="'+(coin.raw_data[field]>0?'change-up':(coin.raw_data[field]<0?'change-down':''))+'">'+coin[field]+'</span></td>';
          } else if (field == 'intraday_quotes') {
            row += '<td class="performance-sparkline right-align" data-title="'+TEXT[field]+'"><span values="'+coin[field].p.join(',')+'"></span></td>';
          } else {
            row += '<td class="right-align" data-title="'+TEXT[field]+'">'+coin[field]+'</td>';
          }
        }
        row += '</tr>';
        var $row = $(row);
        $row.appendTo($tableCoins);
        if (COINS_REALTIME_FEED && coin.ws_disabled==0) {
          subs.push('5~CCCAGG~' + coin.symbol + '~USD');
          marketData[coin.symbol] = {
            row: $row,
            lastPrice: 0
          };
        }
      });
      offset += COINS_LIMIT;
      if (subs.length)
        realTimeDataFeed.subscribe(subs);
      $('.performance-sparkline span')
        .not('.sparkline-added')
        .displaySparklineCharts();
    }
  }

  function initRealTimeFeed() {
    var subs = [];
    $('.coin-row').each(function (i, row) {
      var $row = $(row);
      if($row.hasClass('ws-disabled'))return;
      var symbol = $row.data('symbol');
      subs.push('5~CCCAGG~'+symbol+'~USD');
      marketData[symbol] = {
        row: $row,
        lastPrice: 0
      };
    });
    if (subs.length) {
      realTimeDataFeed = new RealTimeDataFeed({
        subs: subs,
        onAggQuote: function (quote) {
          var symbol = quote.FROMSYMBOL;
          var coinLastPrice = marketData[symbol].lastPrice;

          if (typeof quote.PRICE != 'undefined') {
            var currentPrice = quote.PRICE * DISPLAY_CURRENCY.rate;
            var lastTickChange = coinLastPrice > 0 ?  currentPrice - coinLastPrice : 0;
            var $coinPrice = marketData[symbol].row.find('.coin-price-value');
            $coinPrice.text(formatDecimal(currentPrice));
            marketData[symbol].row.addClass(lastTickChange > 0 ? 'animate-green' : (lastTickChange < 0 ? 'animate-red' : ''));
            setTimeout(function () {
              marketData[symbol].row.removeClass('animate-green animate-red');
            }, 500);
            marketData[symbol].lastPrice = currentPrice;
          }
          if (typeof quote.OPEN24HOUR != 'undefined' && coinLastPrice > 0) {
            var openPrice = quote.OPEN24HOUR * DISPLAY_CURRENCY.rate;
            var absChange = coinLastPrice - openPrice;
            var pctChange = coinLastPrice / openPrice - 1;
            var $coinAbsChange = marketData[symbol].row.find('.coin-change-value');
            var $coinPctChange = marketData[symbol].row.find('.coin-change_pct-value');
            $coinAbsChange.text(formatDecimal(absChange));
            $coinPctChange.text(formatPercentage(pctChange));
            if (absChange > 0 && $coinAbsChange.hasClass('change-down'))
              $coinAbsChange.removeClass('change-down').addClass('change-up');
            if (absChange < 0 && $coinAbsChange.hasClass('change-up'))
              $coinAbsChange.removeClass('change-up').addClass('change-down');
            if (pctChange > 0 && $coinPctChange.hasClass('change-down'))
              $coinPctChange.removeClass('change-down').addClass('change-up');
            if (pctChange < 0 && $coinPctChange.hasClass('change-up'))
              $coinPctChange.removeClass('change-up').addClass('change-down');
          }
          if (typeof quote.OPEN24HOUR != 'undefined')
            marketData[symbol].row.find('.coin-open-value').text(formatDecimal(quote.OPEN24HOUR * DISPLAY_CURRENCY.rate));
          if (typeof quote.HIGH24HOUR != 'undefined')
            marketData[symbol].row.find('.coin-high-value').text(formatDecimal(quote.HIGH24HOUR * DISPLAY_CURRENCY.rate));
          if (typeof quote.LOW24HOUR != 'undefined')
            marketData[symbol].row.find('.coin-low-value').text(formatDecimal(quote.LOW24HOUR * DISPLAY_CURRENCY.rate));
          if (typeof quote.VOLUME24HOUR != 'undefined')
            marketData[symbol].row.find('.coin-volume-value').text(formatDecimal(quote.VOLUME24HOUR));
          if (typeof quote.VOLUME24HOURTO != 'undefined')
            marketData[symbol].row.find('.coin-volume_ccy-value').text(formatDecimal(quote.VOLUME24HOURTO * DISPLAY_CURRENCY.rate));
        }
      });
    }
  }
});