<?php

use Phinx\Migration\AbstractMigration;

class CoinCreate extends AbstractMigration {
    /**
     * Migrate Up.
     */
    public function up() {
        $this->execute('CREATE TABLE `coin` (
                      `id` INT NOT NULL,
                      `symbol` VARCHAR(20) NOT NULL,
                      `name` VARCHAR(75) NOT NULL,
                      `logo` VARCHAR(200) NULL,
                      `price` DECIMAL(20,10) NULL,
                      `change` DECIMAL(16,6) NULL,
                      `change_pct` DECIMAL(10,2) NULL,
                      `open` DECIMAL(20,10) NULL,
                      `low` DECIMAL(20,10) NULL,
                      `high` DECIMAL(20,10) NULL,
                      `supply` BIGINT NULL,
                      `market_cap` BIGINT NULL,
                      `volume` BIGINT NULL,
                      `volume_ccy` VARCHAR(45) NULL,
                      `last_updated` DATETIME NULL,
                      `active` TINYINT(1) NOT NULL DEFAULT 1,
                      `proof_type` VARCHAR(50) NULL,
                      `website` VARCHAR(200) NULL,
                      `twitter` VARCHAR(100) NULL,
                      `description` TEXT NULL,
                      `features` TEXT NULL,
                      `technology` TEXT NULL,
                      `total_supply` BIGINT(20) NULL,
                      PRIMARY KEY (`id`))
                      ENGINE=InnoDB
                      CHARACTER SET utf8 COLLATE utf8_general_ci');

        $this->execute('ALTER TABLE `coin` ADD UNIQUE INDEX `uq_coin_symbol` (`symbol` ASC)');
        $this->execute('ALTER TABLE `coin` ADD INDEX `ix_coin_change_pct_asc` (`change_pct` ASC), ADD INDEX `ix_coin_change_pct_desc` (`change_pct` DESC)');
    }

    /**
     * Migrate Down.
     */
    public function down() {
        $this->execute('DROP TABLE `coin`');
    }
}