<?php

use Phinx\Migration\AbstractMigration;

class CurrencyCreate extends AbstractMigration {
    /**
     * Migrate Up.
     */
    public function up() {
        $this->execute('CREATE TABLE `currency` (
                          `symbol` CHAR(3) NOT NULL,
                          `name` VARCHAR(100) NOT NULL,
                          `code` VARCHAR(10) NOT NULL,
                          `code_native` VARCHAR(10) NOT NULL,
                          `rate` DECIMAL(10,5) NULL,
                          `last_updated` DATETIME NULL,
                          PRIMARY KEY (`symbol`),
                          UNIQUE INDEX `symbol_UNIQUE` (`symbol` ASC))
                          ENGINE=InnoDB
                          CHARACTER SET utf8 COLLATE utf8_general_ci');
    }

    /**
     * Migrate Down.
     */
    public function down() {
        $this->execute('DROP TABLE `currency`');
    }
}
