<?php

use Phinx\Migration\AbstractMigration;

class UserCreate extends AbstractMigration {
  /**
   * Migrate Up.
   */
  public function up() {
    $this->execute('CREATE TABLE `user` (
                    `id` INT NOT NULL AUTO_INCREMENT,
                    `first_name` VARCHAR(100) NULL,
                    `last_name` VARCHAR(100) NULL,
                    `email` VARCHAR(200) NOT NULL,
                    `password` VARCHAR(60) NOT NULL,
                    `admin` TINYINT(1) NULL DEFAULT 0,
                    `created` DATETIME NULL,
                    `last_login` DATETIME NULL,
                    PRIMARY KEY (`id`))
                    ENGINE=InnoDB
                    CHARACTER SET utf8 COLLATE utf8_general_ci');

    $this->execute('ALTER TABLE `user` ADD UNIQUE INDEX `uq_user_email` (`email` ASC)');
  }

  /**
   * Migrate Down.
   */
  public function down() {
    $this->execute('DROP TABLE `user`');
  }
}
