<?php


use Phinx\Migration\AbstractMigration;

class FavoriteCoinCreate extends AbstractMigration {
  /**
   * Change Method.
   *
   * Write your reversible migrations using this method.
   *
   * More information on writing migrations is available here:
   * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
   *
   * The following commands can be used in this method and Phinx will
   * automatically reverse them when rolling back:
   *
   *    createTable
   *    renameTable
   *    addColumn
   *    renameColumn
   *    addIndex
   *    addForeignKey
   *
   * Remember to call "create()" or "update()" and NOT "save()" when working
   * with the Table class.
   */
  public function change() {
    // if the below tables were created as MyISAM the favorite_coin table creation will fail, so altering engine explicitly
    $this->execute('ALTER TABLE `coin` ENGINE="InnoDB";');
    $this->execute('ALTER TABLE `currency` ENGINE="InnoDB";');
    $this->execute('ALTER TABLE `user` ENGINE="InnoDB";');

    $table = $this->table('favorite_coin', ['engine' => 'InnoDB']);
    // Phinx automatically creates an auto-incrementing primary key column called id for every table.
    $table
      ->addColumn('user_id', 'integer')
      ->addColumn('coin_id', 'integer')
      ->addColumn('created', 'datetime')
      ->addIndex(['user_id', 'coin_id'], ['unique' => true, 'name' => 'uq_favorite_coin'])
      ->addIndex(['user_id'], ['unique' => false, 'name' => 'ix_favorite_coin_coin_id'])
      ->addForeignKey('user_id', 'user', 'id', ['delete'=> 'CASCADE', 'update'=> 'CASCADE', 'constraint' => 'fk_favorite_coin_user'])
      ->addForeignKey('coin_id', 'coin', 'id', ['delete'=> 'CASCADE', 'update'=> 'CASCADE', 'constraint' => 'fk_favorite_coin_coin'])
      ->create();
  }
}
