<?php

define('APP_VERSION', '1.5.5');
define('MIN_PHP_VERSION', '5.5.0');

if (version_compare(PHP_VERSION, MIN_PHP_VERSION, '<'))
	die('Please install PHP ' . MIN_PHP_VERSION . ' or above');

require 'vendor/autoload.php';
// Kickstart the framework
$f3 = require('vendor/bcosca/fatfree-core/base.php');

// on first install rename main config file
if (!file_exists('config/framework.ini') && file_exists('config/.framework.ini'))
  copy('config/.framework.ini', 'config/framework.ini');

// on first install rename main custom routes file
if (!file_exists('config/routes-udf.ini') && file_exists('config/.routes-udf.ini'))
	copy('config/.routes-udf.ini', 'config/routes-udf.ini');

// Load configuration
$f3->config('config/framework.ini'); // main config file
$f3->config('config/routes.ini'); // system routes
$f3->config('config/routes-udf.ini'); // user routes overrides

// log all PHP errors to app log file
ini_set('log_errors', TRUE);
ini_set('error_log', __DIR__ . '/' . \Inc\Logger::LOG_FILE);

// Error page handler
$f3->set('ONERROR','Controller\Page->errorPage');

// set default currency if it is not yet set
// not that setting it via $f3->set('COOKIE.currency', $f3->get('SITE.CURRENCY')) doesn't work
if (!isset($_COOKIE['currency']))
	setcookie('currency', $f3->get('SITE.CURRENCY'), time() + \Controller\UserSetting::DAYS365);

// set default timezone from settings
date_default_timezone_set($f3->get('TZ'));

$f3->run();

?>
